;*****
; key.asm - keyboard handling.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __KEY__ equ 1
                include "pmlib.asd"
                include "key.asi"



proc            KeyWait
                ;in
                ;  nothing
                ;out
                ;  eax - key code
                ;description
                ;  Waits for a keypress and returns key code.
                xor     eax, eax
                int     16h
                movzx   eax, ax
                and     al, al
                @IF_NZ
                  xor   ah, ah
                @ENDIF
		ret
endp



proc            KeyNoWait
                ;in
                ;  nothing
                ;out
                ;  eax - key code
                ;description
                ;  Checks the keyboard input buffer. If it contains key code,
                ;  retrives code from buffer. If it contains nothing, returns
                ;  zero.
                mov     ah, 1
                int     16h
                @IF_Z
                  xor   eax, eax
                @ELSE
                  call  KeyWait
                @ENDIF
		ret
endp



proc            KeyRShiftPressed
                ;in
                ;  nothing
                ;out
                ;  CN: right shift is pressed
                ;  CY: right shift is not pressed
                mov     ah, 2
                int     16h
                test    al, 1
                @IF_Z
                  stc
                @ELSE
                  clc
                @ENDIF
		ret
endp



proc            KeyLShiftPressed
                ;in
                ;  nothing
                ;out
                ;  CN: left shift is pressed
                ;  CY: left shift is not pressed
                mov     ah, 2
                int     16h
                test    al, 2
                @IF_Z
                  stc
                @ELSE
                  clc
                @ENDIF
		ret
endp



proc            KeyCtrlPressed
                ;in
                ;  nothing
                ;out
                ;  CN: ctrl is pressed
                ;  CY: ctrl is not pressed
                mov     ah, 2
                int     16h
                test    al, 4
                @IF_Z
                  stc
                @ELSE
                  clc
                @ENDIF
		ret
endp



proc            KeyAltPressed
                ;in
                ;  nothing
                ;out
                ;  CN: alt is pressed
                ;  CY: alt is not pressed
                mov     ah, 2
                int     16h
                test    al, 8
                @IF_Z
                  stc
                @ELSE
                  clc
                @ENDIF
		ret
endp

ends            code32
                end
