;*****
; irq.asm - interrupt requests handling.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __IRQ__ equ 1
                include "pmlib.asd"
                include "error.asi"
                include "irq.asi"



struc           irq             ;'Irq' structure
  bPort         db      0       ;mask port
  bMask         db      0       ;mask for state reading
  dSystemHnd1   dd      0       ;first handler address
  dSystemHnd2   dd      0       ;second handler address
  bDejaVu       db      0       ;second call detection
  bState        db      0       ;state saving
  wPrevHndSel   dw      0       ;previous handler selector
  dPrevHndOfs   dd      0       ;previous handler address
  dUserHnd1     dd      0       ;first user handler address
  dUserHnd2     dd      0       ;second user handler address
ends

                irp     I,<0,1,2,3,4,5,6,7>
sIrq&I          irq     <021h, (1 SHL I), SysHnd1&I, SysHnd2&I>
                endm
                irp     I,<8,9,10,11,12,13,14,15>
sIrq&I          irq     <0A1h, (1 SHL (I-8)), SysHnd1&I, SysHnd2&I>
                endm

RUS_MESSAGE     cErrDejaVu1     "ୠ ⠭ IRQ ⨬."
ENG_MESSAGE     cErrDejaVu1     "Can not set IRQ twice."
RUS_MESSAGE     cErrDejaVu2     "୮ ⠭ IRQ ⨬."
ENG_MESSAGE     cErrDejaVu2     "Can not restore IRQ twice."



proc            IrqSetHandler
                ;in
                ;  eax - irq number
                ;  ebx - critical section handler
                ;  ecx - non-critical section handler
                ;ouu
                ;  nothing
                pushad

                push    eax                     ;save irq number

                ;;get in esi ptr to 'Irq' structure
                mov     esi, size irq
                mul     esi
                lea     esi, [sIrq0]
                add     esi, eax

                ;;save user handlers addresses
                mov     [(irq esi).dUserHnd1], ebx
                mov     [(irq esi).dUserHnd2], ecx

                ;;check for recurrent call
                cmp     [(irq esi).bDejaVu], 1
                @IF_E
                  lea   esi, [cErrDejaVu1]
                  call  ErrorFatal
                @ENDIF
                inc     [(irq esi).bDejaVu]

                ;;save irq mask
                xor     edx, edx
                mov     dl, [(irq esi).bPort]
                in      al, dx
                and     al, [(irq esi).bMask]
                mov     [(irq esi).bState], al

                ;;get in bl irq number
                mov     ax, 0400h
                int     31h
                pop     ebx                     ;restore irq number
                cmp     bl, 8
                @IF_AE
                  sub   bl, 8
                  mov   dh, dl
                @ENDIF
                add     bl, dh

                ;;save old handler
                mov     ax, 0204h
                int     31h
                mov     [(irq esi).wPrevHndSel], cx     ;selector
                mov     [(irq esi).dPrevHndOfs], edx    ;offset

                ;;set new handler
                mov     ax, 0205h
                mov     cx, cs                          ;selector
                cmp     [(irq esi).dUserHnd2], 0
                mov     edx, [(irq esi).dSystemHnd1]
                @IF_NE
                  mov   edx, [(irq esi).dSystemHnd2]
                @ENDIF
                int     31h

                ;;unmask interrupts
                xor     edx, edx
                mov     dl, [(irq esi).bPort]
                in      al, dx
                mov     ah, [(irq esi).bMask]
                xor     ah, 0FFh
                and     al, ah
                out     dx, al

                popad
                ret
endp



proc            IrqRestoreHandler
                ;in
                ;  eax - irq number
                ;out
                ;  nothing
                pushad

                push    eax                     ;save irq number

                ;;get in esi ptr to 'Irq' structure
                mov     esi, size irq
                mul     esi
                lea     esi, [sIrq0]
                add     esi, eax

                ;;check for recurrent call
                cmp     [(irq esi).bDejaVu], 0
                @IF_E
                  lea   esi, [cErrDejaVu2]
                  call  ErrorFatal
                @ENDIF
                dec     [(irq esi).bDejaVu]

                ;;restore interrupt mask
                xor     edx, edx
                mov     dl, [(irq esi).bPort]
                in      al, dx
                or      al, [(irq esi).bState]
                out     dx, al

                ;;get in bl irq number
                mov     ax, 0400h
                int     31h
                pop     ebx                     ;restore irq number
                cmp     bl, 8
                @IF_AE
                  sub   bl, 8
                  mov   dh, dl
                @ENDIF
                add     bl, dh

                ;;restore old handler
                mov     ax, 0205h
                mov     cx, [(irq esi).wPrevHndSel]     ;selector
                mov     edx, [(irq esi).dPrevHndOfs]    ;offset
                int     31h

                popad
                ret
endp



                irp     I,<0,1,2,3,4,5,6,7>
proc            SysHnd1&I
                push    eax
                call    [sIrq&I.dUserHnd1]
                mov     al, 20h
                out     20h, al
                pop     eax
                db      0CFh    ;iret
endp            SysHnd1&I
proc            SysHnd2&I
                push    eax
                call    [sIrq&I.dUserHnd1]
                mov     al, 20h
                out     20h, al
                sti
                call    [sIrq&I.dUserHnd2]
                pop     eax
                db      0CFh    ;iret
endp            SysHnd2&I
                endm
                irp     I,<8,9,10,11,12,13,14,15>
proc            SysHnd1&I
                push    eax
                call    [sIrq&I.dUserHnd1]
                mov     al, 0A0h
                out     0A0h, al
                pop     eax
                db      0CFh    ;iret
endp            SysHnd1&I
proc            SysHnd2&I
                push    eax
                call    [sIrq&I.dUserHnd1]
                mov     al, 0A0h
                out     0A0h, al
                sti
                call    [sIrq&I.dUserHnd2]
                pop     eax
                db      0CFh    ;iret
endp            SysHnd2&I
                endm

ends            code32
                end
