;*****
; host.asm - host operating system type
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __HOST__  equ 1
                include "pmlib.asd"
                include "host.asi"
                include "timer.asi"



INT_NOT_CHECKED equ     0               ;Int 2Fh not checked yet
INT_NOT_AVAIL   equ     1               ;Int 2Fh not available
INT_AVAILABLE   equ     2               ;Int 2Fh available

bInt2FStatus    db      INT_NOT_CHECKED
dTimer          dd      0



proc            HostType
                call    HostCheckInt2F
                cmp     [bInt2FStatus], INT_AVAILABLE
                @IF_E
                  mov   ax, 1600h
                  int   2Fh
                  and   al, 7Fh
                @ELSE
                  mov   al, 0
                @ENDIF
                ret
endp



proc            HostReleaseTimeslice
                call    HostCheckInt2F
                cmp     [bInt2FStatus], INT_AVAILABLE
                @IF_E
                  call  TimerGetSystemTicks
                  sub   eax, [dTimer]
                  cmp   eax, 10
                  @IF_A
                    ;;release timeslice
                    mov ax, 1680h
                    int 2Fh
                    ;;set timer
                    call TimerGetSystemTicks
                    mov  [dTimer], eax
                  @ENDIF
                @ENDIF
                ret
endp



proc            HostCheckInt2F
                cmp     [bInt2FStatus], INT_NOT_CHECKED
                @IF_E
                  mov   eax, [fs:02Fh*4]
                  and   eax, eax
                  @IF_Z
                    mov [bInt2FStatus], INT_NOT_AVAIL
                  @ELSE
                    mov [bInt2FStatus], INT_AVAILABLE
                  @ENDIF
                @ENDIF
                ret
endp

ends            code32
                end
