;*****
; hm.asm  -  upper memory management
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __HM__  equ 1
                include "pmlib.asd"
                include "api.asi"
                include "error.asi"
                include "hm.asi"



RUS_MESSAGE     cErrAlloc       "訡  뤥 孥 ."
ENG_MESSAGE     cErrAlloc       "Upper memory allocation error."
RUS_MESSAGE     cErrLock        "訡  ஢ 孥 ."
ENG_MESSAGE     cErrLock        "Upper memory locking error."
RUS_MESSAGE     cErrUnLock      "訡  ࠧ஢ 孥 ."
ENG_MESSAGE     cErrUnLock      "Upper memory unlocking error."
RUS_MESSAGE     cErrFree        "訡  ᢮ 孥 ."
ENG_MESSAGE     cErrFree        "Upper memory freeing error."



proc            HmAlloc
                ;in
                ;  eax - size
                ;out
                ;  eax - allocated memory start
                ;  ebx - allocated memory descriptor
                push    ecx esi edi
                push    eax
                pop     cx bx
                mov     ax, 501h
                int     31h
                @IF_C
                  lea   esi, [cErrAlloc]
                  call  ErrorFatal
                @ENDIF
                push    bx cx
                pop     eax
                push    si di
                pop     ebx
                sub     eax, [dBaseAddr]
                pop     edi esi ecx
                ret
endp



proc            HmLock
                ;in
                ;  eax - start of previously allocated memory
                ;  ebx - size
                ;out
                ;  nothing
                pushad

                ;;check upper memory availability
                pushad
                mov     ax, 400h
                int     31h
                test    bl, 4
                popad
                jz      @@exit

                ;;upper memory present - lock it
                push    ebx
                pop     di si
                add     eax, [dBaseAddr]
                push    eax
                pop     cx bx
                mov     ax, 600h
                int     31h
                @IF_C
                  lea   esi, [cErrLock]
                  call  ErrorFatal
                @ENDIF

@@exit:         popad
                ret
endp



proc            HmUnLock
                ;in
                ;  eax - start of previously allocated memory
                ;  ebx - size
                ;out
                ;  nothing
                pushad

                ;;check upper memory availability
                pushad
                mov     ax, 400h
                int     31h
                test    bl, 4
                popad
                jz      @@exit

                ;;upper memory present - unlock it
                push    ebx
                pop     di si
                add     eax, [dBaseAddr]
                push    eax
                pop     cx bx
                mov     ax, 601h
                int     31h
                @IF_C
                  lea   esi, [cErrUnLock]
                  call  ErrorFatal
                @ENDIF

@@exit:         popad
                ret
endp



proc            HmFree
                ;in
                ;  eax - descriptor of previously allocated memory
                ;out
                ;  nothing
                push    esi edi
                push    eax
                pop     di si
                mov     ax, 502h
                int     31h
                @IF_C
                  lea   esi, [cErrFree]
                  call  ErrorFatal
                @ENDIF
                pop     edi esi
                ret
endp

ends            code32
                end
