;*****
; geometry.asm - geometric primitives.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __GEOMETRY__ equ 1
                include "pmlib.asd"
                include "geometry.asi"
                include "debug.asi"
                include "error.asi"
                include "heap.asi"




abSign          db      0, 0, 0, 0, 0
RUS_MESSAGE     cErrNotPoint    "ꥪ  ਭ  'Point'."
ENG_MESSAGE     cErrNotPoint    "Object is not a 'Point'."
RUS_MESSAGE     cErrNotRect     "ꥪ  ਭ  'Rectangle'."
ENG_MESSAGE     cErrNotRect     "Object is not a 'Rectangle'."




;;
;                                 POINT                                    ;
;;

proc            PointNew
                ;in
                ;  nothing
                ;out
                ;  edi - 'Point'
                mov     eax, size point
                call    HeapAlloc
                mov     [(rect edi).dSign], POINT_SIGN
                ret
endp



proc            PointDelete
                ;in
                ;  esi - 'Point'
                ;out
                ;  nothing
                call    PointCheck
                mov     eax, esi
                call    HeapFree
                ret
endp



proc            PointCheck
                ;in
                ;  esi - 'Point'
                ;out
                ;  nothing
                cmp     [(rect esi).dSign], POINT_SIGN
                @IF_NE
                  lea   esi, [cErrNotPoint]
                  call  ErrorFatal
                @ENDIF
                ret
endp



IF              DBG
proc            PointDump
                ;in
                ;  esi - 'Point'
                ;out
                ;  nothing
                ;description
                ;  Dumps 'Point' structure for debug purposes.
                push    esi
                mov     eax, [(point esi).dSign]
                xchg    ah, al
                rol     eax, 16
                xchg    ah, al
                lea     esi, [abSign]
                mov     [esi], eax
                call    DebugPrintStr
                pop     esi

                mov     eax, [(rect esi).dRow]
                call    DebugPrintEaxDec

                mov     eax, [(rect esi).dCol]
                call    DebugPrintEaxDec

                ret
endp
ENDIF           ;DBG



;;
;                                RECTANGLE                                 ;
;;

proc            RectNew
                ;in
                ;  nothing
                ;out
                ;  edi - 'Rectangle'
                mov     eax, size rect
                call    HeapAlloc
                mov     [(rect edi).dSign], RECT_SIGN
                ret
endp



proc            RectDelete
                ;in
                ;  esi - 'Rectangle'
                ;out
                ;  nothing
                call    RectCheck
                mov     eax, esi
                call    HeapFree
                ret
endp



proc            RectCheck
                ;in
                ;  esi - 'Rectangle'
                ;out
                ;  nothing
                cmp     [(rect esi).dSign], RECT_SIGN
                @IF_NE
                  lea   esi, [cErrNotRect]
                  call  ErrorFatal
                @ENDIF
                ret
endp



IF              DBG
proc            RectDump
                ;in
                ;  esi - 'Rectangle'
                ;out
                ;  nothing
                ;description
                ;  Dumps 'Rectangle' structure for debug purposes.
                push    esi
                mov     eax, [(rect esi).dSign]
                xchg    ah, al
                rol     eax, 16
                xchg    ah, al
                lea     esi, [abSign]
                mov     [esi], eax
                call    DebugPrintStr
                pop     esi

                mov     eax, [(rect esi).dRow]
                call    DebugPrintEaxDec

                mov     eax, [(rect esi).dCol]
                call    DebugPrintEaxDec

                mov     eax, [(rect esi).dTotalRow]
                call    DebugPrintEaxDec

                mov     eax, [(rect esi).dTotalCol]
                call    DebugPrintEaxDec

                ret
endp
ENDIF           ;DBG


proc            RectIsIntersect
                ;in
                ;  esi - 'Rectangle' 1
                ;  edi - 'Rectangle' 2
                ;out
                ;  CN - rectangles are intersecting
                ;  CY - rectangles are not intersecting
                ;description
                ;  Checks whether the rectangles are intersecting.
                call    RectCheck
                xchg    esi, edi
                call    RectCheck
                xchg    esi, edi

                mov     eax, [(rect esi).dRow]
                sub     eax, [(rect edi).dRow]
                @IF_A
                  inc   eax
                  cmp   [(rect edi).dTotalRow], eax
                  jc    @@exit
                @ELSE
                  neg   eax
                  inc   eax
                  cmp   [(rect esi).dTotalRow], eax
                  jc    @@exit
                @ENDIF

                mov     eax, [(rect esi).dCol]
                sub     eax, [(rect edi).dCol]
                @IF_A
                  inc   eax
                  cmp   [(rect edi).dTotalCol], eax
                @ELSE
                  neg   eax
                  inc   eax
                  cmp   [(rect esi).dTotalCol], eax
                @ENDIF

@@exit:         ret
endp



proc            RectConcatenate
                ;in
                ;  esi - 'Rectangle' 1
                ;  edi - 'Rectangle' 2
                ;out
                ;  nothing
                ;description
                ;  Adds rectangle 2 to rectangle 1.
                pushad

                call    RectCheck
                xchg    esi, edi
                call    RectCheck
                xchg    esi, edi

                mov     eax, [(rect esi).dRow]
                cmp     eax, [(rect edi).dRow]
                @IF_A
                  mov   eax, [(rect edi).dRow]
                @ENDIF

                mov     ebx, [(rect esi).dCol]
                cmp     ebx, [(rect edi).dCol]
                @IF_A
                  mov   ebx, [(rect edi).dCol]
                @ENDIF

                mov     ecx, [(rect esi).dRow]
                add     ecx, [(rect esi).dTotalRow]
                mov     ebp, [(rect edi).dRow]
                add     ebp, [(rect edi).dTotalRow]
                cmp     ecx, ebp
                @IF_B
                  mov   ecx, ebp
                @ENDIF
                sub     ecx, eax

                mov     edx, [(rect esi).dCol]
                add     edx, [(rect esi).dTotalCol]
                mov     ebp, [(rect edi).dCol]
                add     ebp, [(rect edi).dTotalCol]
                cmp     edx, ebp
                @IF_B
                  mov   edx, ebp
                @ENDIF
                sub     edx, ebx

                mov     [(rect esi).dRow], eax
                mov     [(rect esi).dCol], ebx
                mov     [(rect esi).dTotalRow], ecx
                mov     [(rect esi).dTotalCol], edx

                popad
                ret
endp



proc            RectIsPointIn
                ;in
                ;  esi - 'Rectangle'
                ;  edi - 'Point'
                ;out
                ;  CN: 'Point' is inside the 'Rectangle'
                ;  CY: 'Point' is outside the 'Rectangle'
                call    RectCheck
                xchg    esi, edi
                call    PointCheck
                xchg    esi, edi

                mov     eax, [(point edi).dRow]
                sub     eax, [(rect esi).dRow]
                jc      @@exit
                inc     eax
                cmp     [(rect esi).dTotalRow], eax
                jc      @@exit

                mov     eax, [(point edi).dCol]
                sub     eax, [(rect esi).dCol]
                jc      @@exit
                inc     eax
                cmp     [(rect esi).dTotalCol], eax

@@exit:         ret
endp

ends            code32
                end
