;*****
; fontmx.asm - font matrix.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __FONTMX__ equ 1
                include "pmlib.asd"
                include "fontmx.asi"
                include "error.asi"
                include "file.asi"
                include "heap.asi"
                include "pcx.asi"
                include "pic.asi"



sFmxFile        fmxfile <>

RUS_MESSAGE     cErrMsg         "ꥪ  ਭ  'Fontmx'."
ENG_MESSAGE     cErrMsg         "Object is not a 'Fontmx'."



proc            FontmxNew
                ;in
                ;  eax - 'Str' with file name of font matrix
                ;out
                ;  edi - 'Fontmx'
                push    ebx esi

                ;;open file
                mov     esi, eax
                mov     ax, 'r'
                call    FileOpen

                ;;allocate memory for 'Fontmx'
                mov     eax, size fontmx
                call    HeapAlloc
                mov     ebx, edi

                ;;read the file handle
                mov     eax, size fmxfile
                lea     edi, [sFmxFile]
                call    FileReadStr

                ;;initialize variables
                mov     [(fontmx ebx).dSign], FONTMX_SIGN
                mov     eax, [(fmxfile edi).dRowPerChar]
                mov     [(fontmx ebx).dRowPerChar], eax
                mov     eax, [(fmxfile edi).dColPerChar]
                mov     [(fontmx ebx).dColPerChar], eax
                mov     eax, [(fmxfile edi).dBitPerPixel]
                mov     [(fontmx ebx).dBitPerPixel], eax
                mov     eax, [(fmxfile edi).dBytesPerRow]
                mov     [(fontmx ebx).dBytesPerRow], eax
                mov     eax, [(fmxfile edi).dBytesPerChar]
                mov     [(fontmx ebx).dBytesPerChar], eax

                ;;read the font
                mov     eax, [(fontmx ebx).dBytesPerChar]
                shl     eax, 8
                push    eax
                call    HeapAlloc
                mov     [(fontmx ebx).dImagePtr], edi
                pop     eax
                call    FileReadStr

                ;;read array of offsets
                mov     eax, 256
                call    HeapAlloc
                mov     [(fontmx ebx).dOfsPtr], edi
                mov     eax, 256
                call    FileReadStr

                ;;read array of lengthes
                mov     eax, 256
                call    HeapAlloc
                mov     [(fontmx ebx).dLenPtr], edi
                mov     eax, 256
                call    FileReadStr

                ;;close file
                call    FileClose

                mov     edi, ebx
                pop     esi ebx
                ret
endp



proc            FontmxDelete
                ;in
                ;  esi - 'Fontmx'
                ;out
                ;  nothing
                mov     eax, [(fontmx esi).dLenPtr]
                call    HeapFree
                mov     eax, [(fontmx esi).dOfsPtr]
                call    HeapFree
                mov     eax, [(fontmx esi).dImagePtr]
                call    HeapFree
                mov     eax, esi
                call    HeapFree
                ret
endp



proc            FontmxCheck
                ;in
                ;  esi - 'Fontmx'
                ;out
                ;  nothing
                cmp     [(fontmx esi).dSign], FONTMX_SIGN
                @IF_NE
                  lea   esi, [cErrMsg]
                  call  ErrorFatal
                @ENDIF
                ret
endp



;****************************************************************************;
;                  PROCEDURE FOR PCX TO FMX CONVERSION                       ;
;****************************************************************************;

IF              DBG

dPic            dd      0       ;temporary 'Pic'
dTotalCol       dd      0       ;total number of columns in 'Pic'
dImagePtr       dd      0       ;image ptr

RUS_MESSAGE     cErrPcx         "PCX-䠩  ᮤন ࠦ ."
ENG_MESSAGE     cErrPcx         "PCX file does not contain font image."

proc            FontmxNewFromPcx
                ;in
                ;  eax - 'Str' with file name
                ;out
                ;  edi - 'Fontmx'
                push    ebx ecx edx esi
                mov     ebx, eax

                ;;allocate memory for 'Fontmx'
                mov     eax, size fontmx
                call    HeapAlloc
                mov     esi, edi
                ;;allocate memory for array with offsets
                mov     eax, 256
                call    HeapAlloc
                mov     [(fontmx esi).dOfsPtr], edi
                ;;allocate memory for array with lengthes
                mov     eax, 256
                call    HeapAlloc
                mov     [(fontmx esi).dLenPtr], edi

                ;;get 'Pic' in edi
                push    esi
                mov     esi, ebx                        ;file name
                call    PcxToPic
                mov     [dPic], edi
                mov     eax, [(pic edi).dTotalCol]
                mov     [dTotalCol], eax
                mov     eax, [(pic edi).dImagePtr]
                mov     [dImagePtr], eax
                pop     esi

                ;;get font height
                mov     edx, [(pic edi).dImagePtr]
                xor     ecx, ecx
@@loop1:        mov     al, [edx]
                cmp     al, 1                           ;grid color
                @IF_NE
                  add   edx, [(pic edi).dTotalCol]
                  inc   ecx
                  cmp   ecx, 50
                  @IF_A
                    lea  esi, [cErrPcx]
                    call ErrorFatal
                  @ENDIF
                  jmp   @@loop1
                @ENDIF
                mov     [(fontmx esi).dRowPerChar], ecx

                ;;get font width
                mov     edx, [(pic edi).dImagePtr]
                xor     ecx, ecx
@@loop2:        mov     al, [edx]
                cmp     al, 1                           ;grid color
                @IF_NE
                  inc   edx
                  inc   ecx
                  cmp   ecx, 50
                  @IF_A
                    lea  esi, [cErrPcx]
                    call ErrorFatal
                  @ENDIF
                  jmp   @@loop2
                @ENDIF
                mov     [(fontmx esi).dColPerChar], ecx

                ;;use lengthes array as temporary array
                mov     ebx, [(fontmx esi).dLenPtr]
                mov     ecx, 256
@@loop3:        mov     [bptr ebx], 0
                inc     ebx
                loop    @@loop3
                mov     ebx, [(fontmx esi).dLenPtr]

                ;;fill temporary array with color usage flags
                mov     eax, [(pic edi).dTotalRow]
                mul     [(pic edi).dTotalCol]
                mov     ecx, eax
                mov     edx, [(pic edi).dImagePtr]
                xor     eax, eax
@@loop4:        mov     al, [edx]
                inc     edx
                mov     [bptr ebx+eax], 1       ;color usage flag
                loop    @@loop4

                ;;count the number of used colors
                mov     ecx, 256
                xor     eax, eax
@@loop5:        cmp     [bptr ebx], 1
                @IF_E
                  inc   eax
                  cmp   eax, 50
                  @IF_A
                    lea  esi, [cErrPcx]
                    call ErrorFatal
                  @ENDIF
                @ENDIF
                inc     ebx
                loop    @@loop5
                sub     eax, 2
                @IF_BE
                  lea   esi, [cErrPcx]
                  call  ErrorFatal
                @ENDIF
                mov     [(fontmx esi).dBitPerPixel], eax

                ;;get number of bytes per char row and per whole char
                mov     eax, [(fontmx esi).dColPerChar]
                mul     [(fontmx esi).dBitPerPixel]
                mov     ebx, eax
                and     ebx, 7
                @IF_NZ
                  add   eax, 8
                @ENDIF
                shr     eax, 3
                mov     [(fontmx esi).dBytesPerRow], eax
                mul     [(fontmx esi).dRowPerChar]
                mov     [(fontmx esi).dBytesPerChar], eax

                ;;allocate and clear memory for font image
                shl     eax, 8
                mov     ecx, eax
                call    HeapAlloc
                mov     [(fontmx esi).dImagePtr], edi
                shr     ecx, 2
                xor     eax, eax
                rep     stosd

                ;;convert font image
                mov     edi, [(fontmx esi).dImagePtr]
                mov     ebx, [dPic]
                mov     ebp, [(pic ebx).dTotalCol]
                xor     edx, edx                ;counter of chars in column
@@loop6:        xor     ecx, ecx                ;counter of chars in row
@@loop7:        push    ebx ecx edx
                  ;;;
                  mov   eax, [(fontmx esi).dRowPerChar]
                  inc   eax
                  mul   edx
                  mul   [(pic ebx).dTotalCol]
                  mov   ebx, [(pic ebx).dImagePtr]
                  add   ebx, eax
                  mov   eax, [(fontmx esi).dColPerChar]
                  inc   eax
                  mul   ecx
                  add   ebx, eax
                  ;
                  mov   edx, [(fontmx esi).dRowPerChar] ;number of points in col
@@loop8:          mov   ecx, [(fontmx esi).dColPerChar] ;number of points in row
                  add   ebx, [(fontmx esi).dColPerChar]
@@loop9:          dec   ebx
                  mov   al, [ebx]
                  cmp   al, 0           ;transparent color
                  @IF_NE
                    sub al, 1
                  @ENDIF
                    ;;;
                    push ecx
                    mov  ecx, [(fontmx esi).dBitPerPixel]
@@loop10:           rcr  al, 1
                      ;;;
                      push ecx edi
                      mov  ecx, [(fontmx esi).dBytesPerRow]
@@loop11:             rcr  [bptr edi], 1
                      inc  edi
                      loop @@loop11
                      pop  edi ecx
                      ;;;
                    loop @@loop10
                    pop  ecx
                    ;;;
                  loop  @@loop9
                  add   ebx, ebp
                  add   edi, [(fontmx esi).dBytesPerRow]
                  dec   edx
                  jnz   @@loop8
                  ;;;
                pop     edx ecx ebx
                inc     ecx
                cmp     ecx, 16
                jb      @@loop7
                inc     edx
                cmp     edx, 16
                jb      @@loop6

                ;;fill array of lengthes and array of offsets for
                ;;proportional printing
                xor     edx, edx                ;counter of points in col
@@loop12:       xor     ecx, ecx                ;counter of points in row
@@loop13:       push    ecx edx
                  ;;;
                  mov   eax, [(fontmx esi).dRowPerChar]
                  inc   eax
                  mul   edx
                  mul   [dTotalCol]
                  mov   edi, [dImagePtr]
                  add   edi, eax
                  mov   eax, [(fontmx esi).dColPerChar]
                  inc   eax
                  mul   ecx
                  add   edi, eax        ;edi-ptr to symbol image
                  ;
                  mov   edx, [(fontmx esi).dRowPerChar] ;number of points in col
                  mov   eax, 00FF0000h                  ;four counters
@@loop14:         mov   ecx, [(fontmx esi).dColPerChar] ;number of points in row
                  xor   ax, ax                          ;two counters
                  push  edi
@@loop15:         cmp   [bptr edi], 0   ;transparent color
                  @IF_E
                    inc  edi
                    inc  al             ;offset counter
                    loop @@loop15
                    shld ebx, eax, 16
                    mov  al, bl         ;empty row - counter not needed
                    jmp  @@next_line
                  @ENDIF
@@loop16:         cmp   [bptr edi], 0   ;transparent color
                  @IF_NE
                    mov  ebx, [(fontmx esi).dColPerChar]
                    sub  ebx, ecx
                    inc  ebx
                    mov  ah, bl         ;length counter
                  @ENDIF
                  inc   edi
                  loop  @@loop16
                  ;
@@next_line:      shld  ebx, eax, 16
                  cmp   bl, al
                  @IF_A
                    mov bl, al          ;choose minimal offset
                  @ENDIF
                  cmp   bh, ah
                  @IF_B
                    mov bh, ah          ;choose maximal length
                  @ENDIF
                  shrd  eax, ebx, 16
                  ;
                  pop   edi
                  add   edi, [dTotalCol]
                  dec   edx
                  jnz   @@loop14
                  ;;;
                pop     edx ecx
                shld    ebx, eax, 16
                cmp     bl, 0FFh
                @IF_E
                  mov   bl, 0
                @ENDIF
                sub     bh, bl
                cmp     bh, 0
                @IF_E
                  mov   bh, 4
                @ENDIF
                mov     eax, edx
                shl     eax, 4
                add     eax, ecx
                push    eax
                add     eax, [(fontmx esi).dOfsPtr]
                mov     [eax], bl
                pop     eax
                add     eax, [(fontmx esi).dLenPtr]
                mov     [eax], bh
                ;
                inc     ecx
                cmp     ecx, 16
                jb      @@loop13
                inc     edx
                cmp     edx, 16
                jb      @@loop12

                ;;'Fontmx'
                mov     edi, esi

                ;;delete temporary 'Pic'
                mov     esi, [dPic]
                call    PicDelete

                pop     esi edx ecx ebx
                ret
endp



proc            FontmxSaveFmx
                ;in
                ;  eax - 'Str' with file name
                ;  esi - 'FGontmx'
                ;out
                ;  nothing
                ;description
                ;  Saves 'Fontmx' as FMX file.
                pushad
                mov     edx, esi

                ;;open file
                mov     esi, eax
                mov     ax, 'w'
                call    FileOpen

                ;;write heading
                lea     edi, [sFmxFile]
                mov     eax, [(fontmx edx).dRowPerChar]
                mov     [(fmxfile edi).dRowPerChar], eax
                mov     eax, [(fontmx edx).dColPerChar]
                mov     [(fmxfile edi).dColPerChar], eax
                mov     eax, [(fontmx edx).dBitPerPixel]
                mov     [(fmxfile edi).dBitPerPixel], eax
                mov     eax, [(fontmx edx).dBytesPerRow]
                mov     [(fmxfile edi).dBytesPerRow], eax
                mov     eax, [(fontmx edx).dBytesPerChar]
                mov     [(fmxfile edi).dBytesPerChar], eax
                mov     eax, size fmxfile
                call    FileWriteStr

                ;;write font
                mov     eax, [(fontmx edx).dBytesPerChar]
                shl     eax, 8
                mov     edi, [(fontmx edx).dImagePtr]
                call    FileWriteStr

                ;;write array of offsets
                mov     eax, 256
                mov     edi, [(fontmx edx).dOfsPtr]
                call    FileWriteStr

                ;;write array of lengthes
                mov     eax, 256
                mov     edi, [(fontmx edx).dLenPtr]
                call    FileWriteStr

                ;;close file
                call    FileClose

                popad
                ret
endp

ENDIF           ;DBG

ends            code32
                end
