;*****
; error.asm  -  runtime error handling.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __ERROR__ equ 1
                include "pmlib.asd"
                include "api.asi"
                include "error.asi"
                extrn   HeapRestore:proc



MAX_MSG         equ     81

dOrgStackPtr    dd      ?
cMessage        db      MAX_MSG dup (0)



proc            ErrorInit
                ;in
                ;  eax - initial stack pointer value
                ;out
                ;  nothing
                mov     [dOrgStackPtr], eax
                ret
endp



proc            ErrorFatal
                ;in
                ;  esi - ptr to error message
                ;out
                ;  nothing

                ;;return video system to initial state
                mov     eax, 03h
                int     10h

                ;;deinitialise 'Heap'
                call    HeapRestore

                ;;copy message to buffer
                mov     ecx, MAX_MSG
                lea     edi, [cMessage]
@@loop1:        lodsb
                stosb
                and     al, al
                loopnz  @@loop1
                dec     edi
                mov     [bptr edi], '$'

                ;;print message
                mov     edx, off cMessage
                add     edx, [dBaseAddr]
                mov     ebp, edx
                shr     ebp, 4                  ;segment
                and     dx, 0Fh                 ;offset
                mov     ah, 9                   ;print message function
                call    ApiInt21h

                ;;terminate a program
                mov     esp, [dOrgStackPtr]
                mov     ax, 4c01h
                int     21h
                ret
endp

ends            code32
                end
