;*****
; dialog.asm - dialog window.
;





segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __DIALOG__ equ 1
                include "pmlib.asd"
                include "dialog.asi"
                include "color.asi"
                include "debug.asi"
                include "error.asi"
                include "font.asi"
                include "gfx.asi"
                include "heap.asi"
                include "list.asi"
                include "key.asi"
                include "str.asi"
                include "svga.asi"
                include "threads.asi"
                include "win.asi"
                include "windows.asi"





;;
;                             DIALOG: DATA                                 ;
;;

DBG_RUS_MESSAGE cErrNotDialog "ꥪ  'Dialog'."
DBG_ENG_MESSAGE cErrNotDialog "Object is not 'Dialog'."





;;
;                              ITEM: DATA                                  ;
;;

struc           inpstr dlgitem
  dFont         dd      0       ;font
  dFontSel      dd      0       ;font to print selected part of string
  dStr          dd      0       ;edited string
  dWin          dd      0       ;'Win'
  dWindow       dd      0       ;'Window'
  dThread       dd      0       ;'Thread'
  dCursorFlag   dd      0       ;1-on, 0-off
  dCursorTimer  dd      0       ;timer to turn cursor on and off
  dCursorPos    dd      0       ;cursor position in string
  dHiLightFlag  dd      0       ;1-part of string is hilighted
  dHiLightStart dd      0       ;hilight start
  dHiLightEnd   dd      0       ;hilight end
ends

struc           button dlgitem
  dTextStrz     dd      0               ;text on button
  dTextFont     dd      0               ;text font
  dTextRow      dd      0               ;text row inside button
  dTextCol      dd      0               ;text column inside button
  dWin          dd      0               ;'Win'
  dWindow       dd      0               ;'Window'
  fnDrawNormal  dd      0               ;
  fnDrawPressed dd      0               ;
  fnClick       dd      0               ;
  fnRepeat      dd      0               ;
  dState        dd      0               ;1-left mouse button pressed
ends

struc           text dlgitem
  dTextStrz     dd      0               ;text
  dTextFont     dd      0               ;text font
ends

DBG_RUS_MESSAGE cErrNotDlgItem "ꥪ  'DlgItem'."
DBG_ENG_MESSAGE cErrNotDlgItem "Object is not 'DlgItem'."
DBG_ENG_MESSAGE cErrNotInpStr  "Object is not a 'InpString'."
DBG_ENG_MESSAGE cErrNotButton  "Object is not a 'Button'."





;;
;                             DIALOG: CODE                                 ;
;;

proc            DialogNew
                ;in
                ;  eax - total number of rows
                ;  ebx - total number of columns
                ;out
                ;  edi - 'Dialog'

                ;;save total number of rows
                push    eax

                ;;create list
                call    ListNew
                push    edi

                ;;allocate memory for 'Dialog'
                mov     eax, size dialog
                call    HeapAlloc

                ;;initialize variables
                mov     [(dialog edi).dSign], DIALOG_SIGN
                pop     [(dialog edi).dItemsList]
                pop     [(dialog edi).dTotalRow]
                mov     [(dialog edi).dTotalCol], ebx

                ret
endp



IF DBG
proc            DialogCheck
                ;in
                ;  esi - 'Dialog'
                ;out
                ;  nothing
                cmp     [(dialog esi).dSign], DIALOG_SIGN
                @IF_NE
                  lea   esi, [cErrNotDialog]
                  call  ErrorFatal
                @ENDIF
                ret
endp
ENDIF



proc            DialogDelete
                ;in
                ;  esi - 'Dialog'
                ;out
                ;  nothing
                pushad

                IF DBG
                  call  DialogCheck
                ENDIF

                ;;delete items
                mov     ebx, esi
                mov     esi, [(dialog ebx).dItemsList]
                call    ListFirst
@@loop1:        @IF_NC
                  push  esi
                  mov   esi, eax
                  call  DlgItemDelete
                  pop   esi
                  call  ListNext
                  jmp   @@loop1
                @ENDIF
                call    ListZap
                call    ListDelete

                ;;delete "Window"
                mov     esi, [(dialog ebx).dWindow]
                call    WindowDelete

                ;;delete "Win"
                mov     esi, [(dialog ebx).dWin]
                call    WinDelete

                ;;delete "Dialog"
                mov     eax, ebx
                call    HeapFree

                popad
                ret
endp



proc            DialogEval
                ;in
                ;  esi - 'Dialog'
                ;out
                ;  nothing
                pushad

                IF DBG
                  call  DialogCheck
                ENDIF

                ;;create 'Win'
                push    esi
                call    SvgaGetInfo
                mov     eax, [(dialog esi).dTotalRow]
                mov     ebx, [(dialog esi).dTotalCol]
                call    WinNew
                mov     [(dialog esi).dWin], edi
                ;;draw box
                call    GfxBoxStandard
                mov     esi, edi
                ;;create 'Window'
                call    SvgaGetInfo
                sub     eax, [(win esi).dTotalRow]
                shr     eax, 1
                sub     ebx, [(win esi).dTotalCol]
                shr     ebx, 1
                lea     edx, [WindowMoveEventHnd]
                call    WindowNew
                pop     ebx
                mov     [(dialog ebx).dWindow], edi

                ;;put items on window
                mov     esi, [(dialog ebx).dItemsList]
                call    ListFirst
@@loop1:        @IF_NC
                  push  esi
                  mov   esi, eax
                  call  DlgItemPutOnWindow
                  pop   esi
                  call  ListNext
                  jmp   @@loop1
                @ENDIF

                ;;show window
                mov     esi, [(dialog ebx).dWindow]
                call    WindowUpdate

                popad
                ret
endp





;;
;                            DLGITEM: CODE                                 ;
;;

proc            DlgItemInit
                ;in
                ;  esi - 'Dialog'
                ;  edi - 'DlgItem'
                ;out
                ;  nothing

                ;;initialize variables
                mov     [(dlgitem edi).dSign], DLGITEM_SIGN
                mov     [(dlgitem edi).dDialog], esi
                mov     [(dlgitem edi).dFocus], 0

                ;;insert to items list
                push    esi
                mov     esi, [(dialog esi).dItemsList]
                call    ListInsertLast
                pop     esi

                ret
endp



IF DBG
proc            DlgItemCheck
                ;in
                ;  esi - 'DlgItem'
                ;out
                ;  nothing
                cmp     [(dlgitem esi).dSign], DLGITEM_SIGN
                @IF_NE
                  lea   esi, [cErrNotDlgItem]
                  call  ErrorFatal
                @ENDIF
                ret
endp
ENDIF



proc            DlgItemDelete
                ;in
                ;  esi - 'DlgItem'
                ;out
                ;  nothing
                IF DBG
                  call  DlgItemCheck
                ENDIF
                call    [(dlgitem esi).fnDelete]
                ret
endp



proc            DlgItemPutOnWindow
                ;in
                ;  esi - 'DlgItem'
                ;out
                ;  nothing
                pushad
                IF DBG
                  call  DlgItemCheck
                ENDIF
                mov     eax, [(dlgitem esi).dRow]
                mov     ebx, [(dlgitem esi).dCol]
                mov     ecx, [(dlgitem esi).dDialog]
                mov     ecx, [(dialog  ecx).dWindow]
                call    [(dlgitem esi).fnPutOnWindow]
                popad
                ret
endp



proc            DlgItemGetFocus
                ;in
                ;  esi - 'DlgItem'
                ;out
                ;  nothing
                pushad

                IF DBG
                  call  DlgItemCheck
                ENDIF

                mov     ebx, esi
                mov     esi, [(dlgitem esi).dDialog]
                mov     esi, [(dialog esi).dItemsList]
                call    ListFirst
@@loop:         @IF_NC
                  push  esi
                  mov   esi, eax
                  cmp   esi, ebx
                  setne cl
                  cmp   [(dlgitem esi).dFocus], 1
                  sete  ch
                  and   cl, ch
                  @IF_NZ
                    call [(dlgitem esi).fnLooseFocus]
                  @ENDIF
                  pop   esi
                  call  ListNext
                  jmp   @@loop
                @ENDIF
                mov     esi, ebx

                call    [(dlgitem esi).fnGetFocus]

                popad
                ret
endp





;;
;                         DLGITEMINPSTR: CODE                              ;
;;

proc            DlgItemInpStrNew
                ;in
                ;  eax - total number of columns
                ;  ebx - 'Font'
                ;  ecx - 'Font' for selected substring
                ;  edx - 'Str'
                ;  esi - 'Dialog'
                ;out
                ;  edi - 'DlgItemInpStr'
                push    esi

                ;;allocate memory for 'InpStr'
                push    eax
                mov     eax, size inpstr
                call    HeapAlloc

                ;;initialize dialog item's variables
                call    DlgItemInit

                ;;initialize input string's variables
                pop     [(inpstr edi).dTotalCol]
                mov     [(inpstr edi).dFont], ebx
                mov     [(inpstr edi).dFontSel], ecx
                mov     [(inpstr edi).dStr], edx
                mov     [(inpstr edi).dHiLightFlag], 0
                mov     [(inpstr edi).dHiLightStart], 0
                mov     [(inpstr edi).dHiLightEnd], 0
                mov     esi, ebx
                call    FontGetRowPerChar
                add     eax, 6
                mov     [(inpstr edi).dTotalRow], eax
                mov     eax, [(str edx).dLength]
                mov     [(inpstr edi).dCursorPos], eax
                lea     eax, [InpStrDelete]
                mov     [(inpstr edi).fnDelete], eax
                lea     eax, [InpStrPutOnWindow]
                mov     [(inpstr edi).fnPutOnWindow], eax
                lea     eax, [InpStrBeginEdit]
                mov     [(inpstr edi).fnGetFocus], eax
                lea     eax, [InpStrEndEdit]
                mov     [(inpstr edi).fnLooseFocus], eax

                pop     esi
                ret
endp



proc            InpStrDelete
                ;in
                ;  esi - ਯ ப 
                ;out
                ;  nothing
                ;description
                ;   ꥪ.
                push    ebx
                IF DBG
                  call  DlgItemCheck
                ENDIF
                mov     ebx, esi
                mov     esi, [(inpstr ebx).dWindow]
                call    WindowDelete
                mov     esi, [(inpstr ebx).dWin]
                call    WinDelete
                mov     eax, ebx
                call    HeapFree
                pop     ebx
                ret
endp



proc            InpStrPutOnWindow
                ;in
                ;  eax - row
                ;  ebx - column
                ;  ecx - parent 'Window'
                ;  esi - InpStr
                ;out
                ;  nothing
                pushad
                push    eax ebx ecx

                ;;ᮧ ஢ 
                call    SvgaGetInfo
                mov     eax, [(inpstr esi).dTotalRow]
                mov     ebx, [(inpstr esi).dTotalCol]
                call    WinNew
                mov     eax, [(inpstr esi).dTotalCol]
                mov     [(win edi).dVisibleCol], eax
                mov     [(inpstr esi).dWin], edi

                ;;⮡ࠧ ப
                call    InpStrDraw

                ;;ᮧ ᮪஢ 
                pop     ecx ebx eax
                push    esi
                lea     edx, [InpStrEventHandler]
                mov     esi, [(inpstr esi).dWin]
                call    WindowChildNew
                mov     esi, edi
                pop     eax
                mov     [(inpstr eax).dWindow], edi
                call    WindowSetOwner

                popad
                ret
endp



proc            InpStrRemoveFromWindow
                ;in
                ;  esi - ਯ ப 
                ;out
                ;  nothing
                pushad

                cmp     [(inpstr esi).dFocus], 1
                @IF_E
                  call  InpStrEndEdit
                @ENDIF

                mov     edi, esi
                mov     esi, [(inpstr edi).dWindow]
                call    WindowDelete
                mov     esi, [(inpstr edi).dWin]
                call    WinDelete

                popad
                ret
endp



proc            InpStrBeginEdit
                ;in
                ;  esi - ਯ ப 
                ;out
                ;  nothing
                pushad

                mov     [(inpstr esi).dFocus], 1
                mov     [(inpstr esi).dCursorTimer], 0
                mov     [(inpstr esi).dHiLightFlag], 1
                mov     [(inpstr esi).dHiLightStart], 0

                mov     edi, [(inpstr esi).dStr]
                mov     eax, [(str edi).dLength]
                mov     [(inpstr esi).dCursorPos], eax
                and     eax, eax
                @IF_NZ
                  dec   eax
                @ENDIF
                mov     [(inpstr esi).dHiLightEnd], eax

                ;;ᮧ 楯
                lea     eax, [InpStrUpdate]
                call    ThreadNew
                mov     [(inpstr esi).dThread], edi

                ;;⮡ࠧ ப
                call    InpStrDraw

                popad
                ret
endp



proc            InpStrEndEdit
                ;in
                ;  esi - ਯ ப 
                ;out
                ;  nothing
                pushad

                mov     [(inpstr esi).dFocus], 0
                mov     [(inpstr esi).dHiLightFlag], 0

                ;;⮡ࠧ ப
                mov     [(inpstr esi).dCursorFlag], 0
                call    InpStrDraw

                ;;㤠 楯
                mov     edi, esi
                mov     esi, [(inpstr edi).dThread]
                call    ThreadDelete

                ;;update window
                mov     esi, [(inpstr edi).dWindow]
                call    WindowUpdate

                popad
                ret
endp



dUpdateFlag     dd      0

proc            InpStrUpdate
                ;in
                ;  esi - ਯ ப 
                ;out
                ;  nothing
                ;description
                ;  ࠡ⪠  ,  .
                pushad
                mov     [dUpdateFlag], 0
                inc     [(inpstr esi).dCursorTimer]

                cmp     [(inpstr esi).dCursorFlag], 1
                @IF_E
                  cmp   [(inpstr esi).dCursorTimer], 30
                  @IF_AE
                    mov [(inpstr esi).dCursorTimer], 0
                    mov [(inpstr esi).dCursorFlag], 0
                    mov [dUpdateFlag], 1
                  @ENDIF
                @ELSE
                  cmp   [(inpstr esi).dCursorTimer], 20
                  @IF_AE
                    mov [(inpstr esi).dCursorTimer], 0
                    mov [(inpstr esi).dCursorFlag], 1
                    mov [dUpdateFlag], 1
                  @ENDIF
                @ENDIF

                ;;ࠡ ⨥ 
                call    KeyNoWait
                and     eax, eax
                jz      @@cont
                mov     [dUpdateFlag], 1
                ;;
                cmp     ax, K_LEFT                      ;५ 
                @IF_E
                  xor   eax, eax
                  cmp   eax, [(inpstr esi).dCursorPos]
                  @IF_B
                    dec [(inpstr esi).dCursorPos]
                  @ENDIF
                  mov   [(inpstr esi).dHiLightFlag], 0
                  mov   [(inpstr esi).dCursorTimer], 0
                  mov   [(inpstr esi).dCursorFlag], 1
                  jmp   @@cont
                @ENDIF
                ;;
                cmp     ax, K_RIGHT                     ;५ ࠢ
                @IF_E
                  mov   eax, [(inpstr esi).dStr]
                  mov   eax, [(str eax).dLength]
                  cmp   eax, [(inpstr esi).dCursorPos]
                  @IF_A
                    inc [(inpstr esi).dCursorPos]
                  @ENDIF
                  mov   [(inpstr esi).dHiLightFlag], 0
                  mov   [(inpstr esi).dCursorTimer], 0
                  mov   [(inpstr esi).dCursorFlag], 1
                  jmp   @@cont
                @ENDIF
                ;;
                cmp     ax, K_HOME                      ; 砫
                @IF_E
                  mov   [(inpstr esi).dCursorPos], 0
                  mov   [(inpstr esi).dHiLightFlag], 0
                  mov   [(inpstr esi).dCursorTimer], 0
                  mov   [(inpstr esi).dCursorFlag], 1
                  jmp   @@cont
                @ENDIF
                ;;
                cmp     ax, K_END                       ; 
                @IF_E
                  mov   eax, [(inpstr esi).dStr]
                  mov   eax, [(str eax).dLength]
                  mov   [(inpstr esi).dCursorPos], eax
                  mov   [(inpstr esi).dHiLightFlag], 0
                  mov   [(inpstr esi).dCursorTimer], 0
                  mov   [(inpstr esi).dCursorFlag], 1
                  jmp   @@cont
                @ENDIF
                ;;
                cmp     ax, K_BACKSPACE                 ;㤠 
                @IF_E
                  cmp   [(inpstr esi).dHiLightFlag], 1
                  @IF_E
                    mov  [(inpstr esi).dHiLightFlag], 0
                    push esi
                    mov  ebx, [(inpstr esi).dHiLightStart]
                    mov  [(inpstr esi).dCursorPos], ebx
                    mov  ecx, [(inpstr esi).dHiLightEnd]
                    mov  esi, [(inpstr esi).dStr]
                    call StrDeleteChars
                    pop  esi
                  @ELSE
                    xor   eax, eax
                    cmp   eax, [(inpstr esi).dCursorPos]
                    @IF_B
                      push esi
                      dec  [(inpstr esi).dCursorPos]
                      mov  ebx, [(inpstr esi).dCursorPos]
                      mov  ecx, [(inpstr esi).dCursorPos]
                      mov  esi, [(inpstr esi).dStr]
                      call StrDeleteChars
                      pop  esi
                    @ENDIF
                  @ENDIF
                  mov   [(inpstr esi).dCursorTimer], 0
                  mov   [(inpstr esi).dCursorFlag], 1
                  jmp   @@cont
                @ENDIF
                ;;
                cmp     ax, K_DELETE                    ;㤠 ⥪騩
                @IF_E
                  cmp   [(inpstr esi).dHiLightFlag], 1
                  @IF_E
                    mov  [(inpstr esi).dHiLightFlag], 0
                    push esi
                    mov  ebx, [(inpstr esi).dHiLightStart]
                    mov  [(inpstr esi).dCursorPos], ebx
                    mov  ecx, [(inpstr esi).dHiLightEnd]
                    mov  esi, [(inpstr esi).dStr]
                    call StrDeleteChars
                    pop  esi
                  @ELSE
                    mov   eax, [(inpstr esi).dStr]
                    mov   eax, [(str eax).dLength]
                    cmp   eax, [(inpstr esi).dCursorPos]
                    @IF_A
                      push esi
                      mov  ebx, [(inpstr esi).dCursorPos]
                      mov  ecx, [(inpstr esi).dCursorPos]
                      mov  esi, [(inpstr esi).dStr]
                      call StrDeleteChars
                      pop  esi
                    @ENDIF
                  @ENDIF
                  mov   [(inpstr esi).dCursorTimer], 0
                  mov   [(inpstr esi).dCursorFlag], 1
                  jmp   @@cont
                @ENDIF
                ;;
                cmp     ax, K_ENTER                     ;ENTER
                sete    bl
                cmp     ax, K_ESC                       ;ESCAPE
                sete    bh
                or      bl, bh
                @IF_NZ
                  call  InpStrEndEdit
                  jmp   @@cont
                @ENDIF
                ;;
                cmp     al, ' '                         ;⠢ ᨬ
                @IF_AE
                  push  eax
                  cmp   [(inpstr esi).dHiLightFlag], 1
                  @IF_E
                    mov  [(inpstr esi).dHiLightFlag], 0
                    push esi
                    mov  ebx, [(inpstr esi).dHiLightStart]
                    mov  [(inpstr esi).dCursorPos], ebx
                    mov  ecx, [(inpstr esi).dHiLightEnd]
                    mov  esi, [(inpstr esi).dStr]
                    call StrDeleteChars
                    pop  esi
                  @ENDIF
                  pop   eax
                  push  esi
                  mov   ebx, [(inpstr esi).dCursorPos]
                  mov   esi, [(inpstr esi).dStr]
                  call  StrInsertChar
                  pop   esi
                  inc   [(inpstr esi).dCursorPos]
                  jmp   @@cont
                @ENDIF

@@cont:         cmp     [dUpdateFlag], 1
                @IF_E
                  call  InpStrDraw
                  mov   esi,[(inpstr esi).dWindow]
                  call  WindowUpdate
                @ENDIF

                popad
                ret
endp



struc           locals
  dStr          dd      0       ;⠥ ப
  dFont         dd      0       ;
  dFontSel      dd      0       ;  뤥
  dWin          dd      0       ;஢ 
  dFocus        dd      0       ;1-⨢ ० ।஢
  dCursorFlag   dd      0       ;1- , 0- 
  dCursorPos    dd      0       ; 
  dHiLightFlag  dd      0       ;1-⨢ ० 뤥
  dHiLightStart dd      0       ;砫 뤥
  dHiLightEnd   dd      0       ; 뤥
  dRow          dd      0       ;ப    
  dCol          dd      0       ;⮫    
  dPos          dd      0       ;㪠⥫  ⥪騩 ⠥ ᨬ
  dColSpace     dd      0       ;஬⮪  ᨬ
ends
proc            InpStrDraw
                ;in
                ;  esi - ਯ ப 
                ;out
                ;  nothing
                ;description
                ;   ப .
                pushad
                sub     esp, size locals
                mov     ebp, esp

                ;;樠஢  ६
                mov     eax, [(inpstr esi).dStr]
                mov     [(locals ebp).dStr], eax
                mov     eax, [(inpstr esi).dFont]
                mov     [(locals ebp).dFont], eax
                mov     eax, [(inpstr esi).dFontSel]
                mov     [(locals ebp).dFontSel], eax
                mov     eax, [(inpstr esi).dWin]
                mov     [(locals ebp).dWin], eax
                mov     eax, [(inpstr esi).dFocus]
                mov     [(locals ebp).dFocus], eax
                mov     eax, [(inpstr esi).dCursorFlag]
                mov     [(locals ebp).dCursorFlag], eax
                mov     eax, [(inpstr esi).dCursorPos]
                mov     [(locals ebp).dCursorPos], eax
                mov     eax, [(inpstr esi).dHiLightFlag]
                mov     [(locals ebp).dHiLightFlag], eax
                mov     eax, [(inpstr esi).dHiLightStart]
                mov     [(locals ebp).dHiLightStart], eax
                mov     eax, [(inpstr esi).dHiLightEnd]
                mov     [(locals ebp).dHiLightEnd], eax

                ;; 砫  
                mov     esi, [(locals ebp).dFont]
                call    FontGetColSpace
                mov     [(locals ebp).dCol], eax
                mov     [(locals ebp).dColSpace], eax
                call    FontGetRowPerChar
                mov     esi, [(locals ebp).dWin]
                sub     eax, [(win esi).dTotalRow]
                neg     eax
                shr     eax, 1
                mov     [(locals ebp).dRow], eax
                mov     [(locals ebp).dPos], 0

                ;; 
                xor     eax, eax
                mov     esi, [(locals ebp).dFont]
                call    FontGetPaletteEntry
                mov     esi, [(locals ebp).dWin]
                call    WinFill

                ;; ப, 뢠 뤥   
@@loop:         mov     esi, [(locals ebp).dStr]
                mov     eax, [(locals ebp).dPos]

                mov     ebx, [(locals ebp).dFocus]
                and     ebx, [(locals ebp).dCursorFlag]
                cmp     eax, [(locals ebp).dCursorPos]
                sete    bh
                and     bl, bh
                @IF_NZ  ; 
                  pushad
                  mov   al, '|'
                  mov   ebx, [(locals ebp).dRow]
                  mov   ecx, [(locals ebp).dCol]
                  sub   ecx, [(locals ebp).dColSpace]
                  mov   esi, [(locals ebp).dFont]
                  mov   edi, [(locals ebp).dWin]
                  call  FontPrintChar
                  popad
                @ENDIF

                cmp     eax, [(str esi).dLength]
                @IF_B
                  ;;⠭ 䫠 Z  롮 
                  mov   ebx, [(locals ebp).dHiLightFlag]
                  cmp   eax, [(locals ebp).dHiLightStart]
                  setae bh
                  and   bl, bh
                  cmp   eax, [(locals ebp).dHiLightEnd]
                  setbe bh
                  and   bl, bh

                  ;; ᨬ  ⥪饩 樨
                  mov   esi, [(str esi).dDataPtr]
                  mov   al, [esi+eax]
                  mov   ebx, [(locals ebp).dRow]
                  mov   ecx, [(locals ebp).dCol]
                  mov   esi, [(locals ebp).dFont]
                  @IF_NZ
                    mov esi, [(locals ebp).dFontSel]
                  @ENDIF
                  mov   edi, [(locals ebp).dWin]
                  call  FontPrintChar
                  mov   [(locals ebp).dCol], ecx

                  inc   [(locals ebp).dPos]
                  jmp   @@loop
                @ENDIF

                add     esp, size locals
                popad
                ret
endp



proc            InpStrEventHandler
                ;in
                ;  al  - event code
                ;  esi - "Window"
                ;  edi - "Window" owner
                ;out
                ;  nothing
                pushad

                cmp     [(inpstr edi).dFocus], 0
                @IF_E
                  cmp   al, EV_LB_DOWN
                  @IF_E
                    mov  esi, edi
                    call DlgItemGetFocus
                  @ENDIF
                  jmp   @@exit
                @ENDIF

                cmp     al, EV_LB_DOWN
                @IF_E
                @ENDIF

@@exit:         popad
                ret
endp





;;
;                         DLGITEMBUTTON: CODE                              ;
;;

proc            DlgItemButtonNew
                ;in
                ;  eax - total number of rows
                ;  ebx - total number of columns
                ;  ecx - 'Strz'
                ;  edx - 'Font'
                ;  esi - 'Dialog'
                ;  edi - click handler
                ;out
                ;  edi - 'DlgItemButton'
                push    ecx esi

                ;;create button
                push    eax ebx edi
                mov     eax, size button
                call    HeapAlloc
                mov     [(button edi).dTextStrz], ecx
                mov     [(button edi).dTextFont], edx
                pop     [(button edi).fnClick]

                ;;initialize dialog item's variables
                call    DlgItemInit

                ;;create 'Win'
                call    SvgaGetInfo
                pop     ebx eax
                xchg    esi, edi
                call    WinNew
                xchg    esi, edi
                mov     [(button edi).dWin], esi

                lea     eax, [DlgItemButtonDelete]
                mov     [(button edi).fnDelete], eax
                lea     eax, [DlgItemButtonPutOnWindow]
                mov     [(button edi).fnPutOnWindow], eax
                lea     eax, [DlgItemButtonVoid]
                mov     [(button edi).fnGetFocus], eax
                lea     eax, [DlgItemButtonVoid]
                mov     [(button edi).fnLooseFocus], eax

                lea     eax, [StdDrawNormalFunction]
                mov     [(button edi).fnDrawNormal], eax
                lea     eax, [StdDrawPressedFunction]
                mov     [(button edi).fnDrawPressed], eax
                lea     eax, [DlgItemButtonVoid]
                mov     [(button edi).fnRepeat], eax

                ;;calculate row
                mov     ecx, [(button edi).dWin]
                mov     ecx, [(win ecx).dTotalRow]
                mov     esi, [(button edi).dTextFont]
                call    FontGetRowPerChar
                sub     ecx, eax
                shr     ecx, 1
                mov     [(button edi).dTextRow], ecx

                ;;calculate column
                mov     ecx, [(button edi).dWin]
                mov     ecx, [(win ecx).dTotalCol]
                push    edi
                mov     edi, [(button edi).dTextStrz]
                call    FontGetStrzLen
                pop     edi
                sub     ecx, eax
                shr     ecx, 1
                mov     [(button edi).dTextCol], ecx

                pop     esi ecx
                ret
endp



proc            DlgItemButtonDelete
                ;in
                ;  esi - 'DlgItemButton'
                ;out
                ;  nothing
                pushad

                IF DBG
                  call  DlgItemCheck
                ENDIF

                mov     edi, esi
                mov     esi, [(button edi).dWindow]
                call    WindowDelete
                mov     esi, [(button edi).dWin]
                call    WinDelete
                mov     eax, edi
                call    HeapFree

                popad
                ret
endp



proc            DlgItemButtonVoid
                ;in
                ;  nothing
                ;out
                ;  nothing
                ret
endp



proc            DlgItemButtonAddRepeatHandler
                ;in
                ;  eax -  㭪樨-ࠡ稪 ⮯
                ;  esi - 'DlgItemButton'
                ;out
                ;  nothing
                IF DBG
                  call  DlgItemCheck
                ENDIF
                mov     [(button esi).fnRepeat], eax
                ret
endp



proc            DlgItemButtonPutOnWindow
                ;in
                ;  eax - row
                ;  ebx - column
                ;  ecx - parent 'Window'
                ;  esi - 'DlgItemButton'
                ;out
                ;  nothing

                IF DBG
                  call  DlgItemCheck
                ENDIF

                push    edx esi edi
                mov     edx, esi

                call    StdDrawNormalFunction

                ;;ᮧ ᮪஢  , ਢ易 
                ;;㪠 த⥫᪮ 
                mov     esi, [(button edx).dWin]
                push    edx
                lea     edx, [ButtonEventHandler]
                call    WindowChildNew
                pop     edx
                mov     [(button edx).dWindow], edi
                mov     eax, edx
                mov     esi, edi
                call    WindowSetOwner

                call    WindowUpdate

                pop     edi esi edx
                ret
endp



proc            DlgItemButtonRemoveFromWindow
                ;in
                ;  esi - 'DlgItemButton'
                ;out
                ;  nothing

                IF DBG
                  call  DlgItemCheck
                ENDIF

                push    esi
                mov     esi, [(button esi).dWindow]
                call    WindowDelete
                pop     esi

                ret
endp



proc            ButtonEventHandler
                ;in
                ;  al  - event code
                ;  esi - "Window"
                ;  edi - "Window" owner
                ;out
                ;  nothing
                pushad

                cmp     al, EV_LB_DOWN
                @IF_E
                  cmp    [(button edi).dFocus], 0
                  @IF_E
                    push esi
                    mov  esi, edi
                    call DlgItemGetFocus
                    pop  esi
                  @ENDIF
                  mov   [(button edi).dState], 1
                  push  esi
                  mov   esi, edi
                  call  [(button esi).fnDrawPressed]
                  pop   esi
                  call  WindowUpdate
                @ENDIF

                cmp     al, EV_LB_DOWN_REP
                @IF_E
                  call  [(button edi).fnRepeat]
                @ENDIF

                cmp     al, EV_CURS_OUT
                @IF_E
                  cmp   [(button edi).dState], 1
                  @IF_E
                    mov  [(button edi).dState], 0
                    push esi
                    mov  esi, edi
                    call [(button esi).fnDrawNormal]
                    pop  esi
                    call WindowUpdate
                  @ENDIF
                @ENDIF

                cmp     al, EV_LB_UP
                @IF_E
                  cmp   [(button edi).dState], 1
                  @IF_E
                    mov  [(button edi).dState], 0
                    push esi
                    mov  esi, edi
                    call [(button esi).fnDrawNormal]
                    pop  esi
                    call WindowUpdate
                    call [(button edi).fnClick]
                  @ENDIF
                @ENDIF

                popad
                ret
endp



proc            StdDrawNormalFunction
                ;in
                ;  esi - 'DlgItemButton'
                ;out
                ;  nothing
                pushad

                IF DBG
                  call  DlgItemCheck
                ENDIF

                mov     edi, [(button esi).dWin]
                call    GfxBoxThinStd

                mov     ebx, [(button esi).dTextRow]
                mov     ecx, [(button esi).dTextCol]
                mov     edx, [(button esi).dTextStrz]
                mov     esi, [(button esi).dTextFont]
                call    FontPrintStrz

                popad
                ret
endp



proc            StdDrawPressedFunction
                ;in
                ;  esi - 'DlgItemButton'
                ;out
                ;  nothing
                pushad

                IF DBG
                  call  DlgItemCheck
                ENDIF

                mov     edi, [(button esi).dWin]
                call    GfxBoxThinInv

                mov     ebx, [(button esi).dTextRow]
                inc     ebx
                mov     ecx, [(button esi).dTextCol]
                inc     ecx
                mov     edx, [(button esi).dTextStrz]
                mov     esi, [(button esi).dTextFont]
                call    FontPrintStrz

                popad
                ret
endp





;;
;                          DLGITEMTEXT: CODE                               ;
;;

proc            DlgItemTextNew
                ;in
                ;  ecx - 'Strz'
                ;  edx - 'Font'
                ;  esi - 'Dialog'
                ;out
                ;  edi - 'DlgItemText'

                ;;allocate memory
                mov     eax, size text
                call    HeapAlloc
                mov     [(text edi).dTextStrz], ecx
                mov     [(text edi).dTextFont], edx

                ;;initialize dialog item's variables
                call    DlgItemInit

                lea     eax, [DlgItemTextDelete]
                mov     [(text edi).fnDelete], eax
                lea     eax, [DlgItemTextPutOnWindow]
                mov     [(text edi).fnPutOnWindow], eax
                lea     eax, [DlgItemTextVoid]
                mov     [(text edi).fnGetFocus], eax
                lea     eax, [DlgItemTextVoid]
                mov     [(text edi).fnLooseFocus], eax

                ret
endp



proc            DlgItemTextDelete
                ;in
                ;  esi - 'DlgItemText'
                ;out
                ;  nothing
                IF DBG
                  call  DlgItemCheck
                ENDIF
                mov     eax, esi
                call    HeapFree
                ret
endp



proc            DlgItemTextVoid
                ;in
                ;  nothing
                ;out
                ;  nothing
                ret
endp



proc            DlgItemTextPutOnWindow
                ;in
                ;  eax - row
                ;  ebx - column
                ;  ecx - parent 'Window'
                ;  esi - 'DlgItemText'
                ;out
                ;  nothing
                pushad
                IF DBG
                  call  DlgItemCheck
                ENDIF
                mov     edi, [(window ecx).dWin]        ;'Win'
                mov     ecx, ebx                        ;column
                mov     ebx, eax                        ;row
                mov     edx, [(text esi).dTextStrz]
                mov     esi, [(text esi).dTextFont]
                call    FontPrintStrz
                popad
                ret
endp



proc            TextEventHandler
                ;in
                ;  al  - event code
                ;  esi - "Window"
                ;  edi - "Window" owner
                ;out
                ;  nothing
                ret
endp

ends            code32
                end
