;*****
; debug.asm  -  debug functions.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __DEBUG__ equ 1
                include "pmlib.asd"
                include "api.asi"
                include "debug.asi"
                include "error.asi"
                include "strz.asi"



cDebugFile      db      "debug.log", 0
dFileHandle     dd      0
cBuffer         db      16 dup(0)

RUS_MESSAGE     cErrOpen        "訡  䠩 ⫠."
ENG_MESSAGE     cErrOpen        "Can not open debug file."
RUS_MESSAGE     cErrWrite       "訡   䠩 ⫠."
ENG_MESSAGE     cErrWrite       "Can not write to debug file."



proc            DebugInit
                ;in
                ;  nothing
                ;out
                ;  nothing
                pushad

                cmp     [dFileHandle], 0
                jne     @@exit

                ;;copy debug file name to low buffer
                lea     esi, [cDebugFile]
                call    ApiStrzToLowBuffer

                mov     ah, 6Ch                 ;extended file open
                mov     bx, 4001h               ;open for write
                xor     ecx, ecx                ;file attributes
                mov     dx, 12h                 ;action on open
                mov     bp, [wLowBufferSeg]     ;file name segment
                mov     si, [wLowBufferOff]     ;file name offset
                call    ApiInt21h
                @IF_C
                  lea   esi, [cErrOpen]
                  call  ErrorFatal
                @ENDIF
                mov     [dFileHandle], eax

@@exit:         popad
                ret
endp



proc            DebugPrintStr
                ;in
                ;  esi - ptr to 'Strz'
                ;室
                ;  祣
                pushad

                call    DebugInit

                ;;copy 'Strz' to low buffer
                call    ApiStrzToLowBuffer
                mov     ax, 0A0Dh
                dec     edi
                stosw

                mov     ah, 40h                 ;write to file
                mov     ebx, [dFileHandle]
                mov     ecx, edi
                lea     edx, [uLowBuffer]
                sub     ecx, edx                ;string length
                mov     bp, [wLowBufferSeg]     ;string segment
                mov     dx, [wLowBufferOff]     ;string offset
                call    ApiInt21h
                jnc     @@cont1
                lea     esi, [cErrWrite]
                call    ErrorFatal

@@cont1:        popad
                ret
endp



proc            DebugPrintEaxHex
                ;in
                ;  eax - number
                ;out
                ;  nothing
                pushad
                lea     edi, [cBuffer]
                call    StrzHexFromLong
                lea     esi, [cBuffer]
                call    DebugPrintStr
                popad
                ret
endp



proc            DebugPrintEaxDec
                ;in
                ;  eax - number
                ;out
                ;  nothing
                pushad
                lea     edi, [cBuffer]
                call    StrzDecFromLong
                lea     esi, [cBuffer]
                call    DebugPrintStr
                popad
                ret
endp



proc            DebugPrintEaxStr
                ;in
                ;  eax - number
                ;out
                ;  nothing
                pushad
                lea     esi, [cBuffer]
                rol     eax, 8
                mov     [esi], al
                rol     eax, 8
                mov     [esi+1], al
                rol     eax, 8
                mov     [esi+2], al
                rol     eax, 8
                mov     [esi+3], al
                xor     eax, eax
                mov     [esi+4], al
                call    DebugPrintStr
                popad
                ret
endp



;;
;                TIME-STAMP COUNTER (FOR PENTIUM PROCESSOR)                ;
;;

dTsc            dd      0



proc            DebugPrintTsc
                ;in
                ;  nothing
                ;out
                ;  nothing
                push    eax
                mov     eax, [dTsc]
                call    DebugPrintEaxDec
                pop     eax
                ret
endp

ends            code32
                end
