;*****
; color.asm - color managing.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __COLOR__ equ 1
                include "pmlib.asd"
                include "color.asi"
                include "cdf.asi"
                include "debug.asi"
                include "error.asi"
                include "heap.asi"
                include "vga.asi"



;;
;                               COLORS                                     ;
;;

adBytesPerCell  dd      1, 1, 2, 2, 3, 4        ;num of BPC in color schemes
dColorSchemeCur dd      0                       ;current color scheme

RUS_MESSAGE     cErrMsgBadParm  "ColorScheme:  ࠬ."
ENG_MESSAGE     cErrMsgBadParm  "ColorScheme: Bad parameter."



proc            ColorSchemeSet
                ;in
                ;  eax - color scheme
                ;out
                ;  nothing
                mov     [dColorSchemeCur], eax
                ret
endp



proc            ColorScheme
                ;in
                ;  al  - number of bits per pixel
                ;out
                ;  eax - color scheme
                cmp     al, 8
                @IF_E
                  mov   eax, COLOR8
                  jmp   short   @@exit
                @ENDIF
                cmp     al, 15
                @IF_E
                  mov   eax, COLOR15
                  jmp   short   @@exit
                @ENDIF
                cmp     al, 16
                @IF_E
                  mov   eax, COLOR16
                  jmp   short   @@exit
                @ENDIF
                cmp     al, 24
                @IF_E
                  mov   eax, COLOR24
                  jmp   short   @@exit
                @ENDIF
                cmp     al, 32
                @IF_E
                  mov   eax, COLOR32
                  jmp   short   @@exit
                @ENDIF
                lea     esi, [cErrMsgBadParm]
                call    ErrorFatal
@@exit:         ret
endp



proc            ColorTrueToCurrent
                ;in
                ;  eax - true color
                ;out
                ;  eax - color in current color scheme
                push    ebx ecx edx

                mov     edx, [dColorSchemeCur]
                cmp     edx, COLOR24
                jae     @@exit

                cmp     edx, COLOR16
                @IF_E
                  mov   ebx, eax
                  mov   ecx, eax
                  and   eax, 0F8h
                  and   ebx, 0FC00h
                  and   ecx, 0F80000h
                  shr   eax, 3
                  shr   ebx, 5
                  shr   ecx, 8
                  or    eax, ebx
                  or    eax, ecx
                @ENDIF

                cmp     edx, COLOR15
                @IF_E
                  mov   ebx, eax
                  mov   ecx, eax
                  and   eax, 0F8h
                  and   ebx, 0F800h
                  and   ecx, 0F80000h
                  shr   eax, 3
                  shr   ebx, 6
                  shr   ecx, 9
                  or    eax, ebx
                  or    eax, ecx
                @ENDIF

@@exit:         pop     edx ecx ebx
                ret
endp



adConvertProc   dd      C0,    C8_88,  C8_15,  C8_16,  C8_24,  C8_32,  C0, C0
                dd      C88_8, C0,     C88_15, C88_16, C88_24, C88_32, C0, C0
                dd      C15_8, C15_88, C0,     C15_16, C15_24, C15_32, C0, C0
                dd      C16_8, C16_88, C16_15, C0,     C16_24, C16_32, C0, C0
                dd      C24_8, C24_88, C24_15, C24_16, C0,     C24_32, C0, C0
                dd      C32_8, C32_88, C32_15, C32_16, C32_24, C0,     C0, C0
                dd      C0,    C0,     C0,     C0,     C0,     C0,     C0, C0
                dd      C0,    C0,     C0,     C0,     C0,     C0,     C0, C0
proc            ColorConvertBlock
                ;in
                ;  eax - color scheme of source block
                ;  ebx - color scheme of destination block
                ;  ecx - number of points in source block
                ;  edx - 'Palette' for color scheme COLOR88
                ;  esi - ptr to source block
                ;  edi - ptr to destination block
                ;out
                ;  nothing
                pushad
                shl     eax, 3
                add     eax, ebx
                call    [adConvertProc+eax*4]
                popad
                ret
endp

proc            C0
                ret
endp

proc            C8_88
                rep     movsb           ;not correct, but OK for now
                ret
endp

proc            C8_15
                lea     edx, [adSystemPalette]
@@loop:         xor     eax, eax
                mov     al, [esi]
                inc     esi
                mov     eax, [edx+eax*4]
                rol     eax, 24
                shld    ebx, eax, 5
                ror     eax, 8
                shld    ebx, eax, 5
                ror     eax, 8
                shld    ebx, eax, 5
                mov     [edi], bx
                add     edi, 2
                loop    @@loop
                ret
endp

proc            C8_16
                lea     edx, [adSystemPalette]
@@loop:         xor     eax, eax
                mov     al, [esi]
                inc     esi
                mov     eax, [edx+eax*4]
                rol     eax, 24
                shld    ebx, eax, 5
                ror     eax, 8
                shld    ebx, eax, 6
                ror     eax, 8
                shld    ebx, eax, 5
                mov     [edi], bx
                add     edi, 2
                loop    @@loop
                ret
endp

proc            C8_24
                lea     edx, [adSystemPalette]
                ret
endp

proc            C8_32
                lea     edx, [adSystemPalette]
@@loop:         xor     eax, eax
                mov     al, [esi]
                inc     esi
                mov     eax, [edx+eax*4]
                xchg    al, ah
                ror     eax, 8
                xchg    al, ah
                rol     eax, 8
                xchg    al, ah
                mov     [edi], eax
                add     edi, 4
                loop    @@loop
                ret
endp

proc            C88_8
                rep     movsb           ;not correct, but OK for now
                ret
endp

proc            C88_15
                ret
endp

proc            C88_16
                lea     edx, [(palette edx).adRGB]
@@loop:         xor     eax, eax
                mov     al, [esi]
                inc     esi
                mov     eax, [edx+eax*4]
                ror     eax, 19
                shrd    ebx, eax, 5
                rol     eax, 9
                shrd    ebx, eax, 6
                rol     eax, 7
                shrd    ebx, eax, 5
                shr     ebx, 16
                mov     [edi], bx
                add     edi, 2
                loop    @@loop
                ret
endp

proc            C88_24
                ret
endp

proc            C88_32
                lea     edx, [(palette edx).adRGB]
@@loop:         xor     eax, eax
                mov     al, [esi]
                inc     esi
                mov     eax, [edx+eax*4]
                xchg    al, ah
                ror     eax, 8
                xchg    al, ah
                rol     eax, 8
                xchg    al, ah
                mov     [edi], eax
                add     edi, 4
                loop    @@loop
                ret
endp

proc            C15_8
                ret
endp

proc            C15_88
                ret
endp

proc            C15_16
                ret
endp

proc            C15_24
                ret
endp

proc            C15_32
                ret
endp

proc            C16_8
                ret
endp

proc            C16_88
                ret
endp

proc            C16_15
                ret
endp

proc            C16_24
                ret
endp

proc            C16_32
                ret
endp

struc           locals
  dNearest      dd      0
  dDistance     dd      0
ends
proc            C24_8
                sub     esp, size locals
                mov     ebp, esp

                xor     eax, eax
@@loop1:        xor     edx, edx
                mov     [(locals ebp).dDistance], 0FFFFFFFFh
@@loop2:        mov     al, [esi]
                sub     al, [bptr adSystemPalette+edx*4]
                @IF_S
                  neg   al
                @ENDIF
                mov     ebx, eax
                mov     al, [esi+1]
                sub     al, [bptr adSystemPalette+1+edx*4]
                @IF_S
                  neg   al
                @ENDIF
                add     ebx, eax
                mov     al, [esi+2]
                sub     al, [bptr adSystemPalette+2+edx*4]
                @IF_S
                  neg   al
                @ENDIF
                add     ebx, eax
                cmp     ebx, [(locals ebp).dDistance]
                @IF_B
                  mov   [(locals ebp).dDistance], ebx
                  mov   [(locals ebp).dNearest], edx
                @ENDIF
                inc     dl
                jnz     @@loop2
                mov     eax, [(locals ebp).dNearest]
                add     esi, 3
                mov     [edi], al
                inc     edi
                loop    @@loop1

                add     esp, size locals
                ret
endp

proc            C24_88
                ret
endp

proc            C24_15
@@loop:         xor     eax, eax
                xor     ebx, ebx
                xor     edx, edx
                mov     al, [esi]
                mov     bl, [esi+1]
                mov     dl, [esi+2]
                shr     eax, 3
                shr     ebx, 3
                shr     edx, 3
                shl     ebx, 5
                shl     edx, 10
                or      eax, ebx
                or      eax, edx
                add     esi, 3
                mov     [edi], ax
                add     edi, 2
                loop    @@loop
                ret
endp

proc            C24_16
@@loop:         xor     eax, eax
                xor     ebx, ebx
                xor     edx, edx
                mov     al, [esi]
                mov     bl, [esi+1]
                mov     dl, [esi+2]
                shr     eax, 3
                shr     ebx, 2
                shr     edx, 3
                shl     ebx, 5
                shl     edx, 11
                or      eax, ebx
                or      eax, edx
                add     esi, 3
                mov     [edi], ax
                add     edi, 2
                loop    @@loop
                ret
endp

proc            C24_32
@@loop:         xor     eax, eax
                xor     ebx, ebx
                xor     edx, edx
                mov     al, [esi]
                mov     bl, [esi+1]
                mov     dl, [esi+2]
                shl     ebx, 8
                shl     edx, 16
                or      eax, ebx
                or      eax, edx
                add     esi, 3
                mov     [edi], eax
                add     edi, 4
                loop    @@loop
                ret
endp

proc            C32_8
                ret
endp

proc            C32_88
                ret
endp

proc            C32_15
@@loop:         mov     eax, [esi]
                add     esi, 4
                shl     eax, 8
                shld    ebx, eax, 5
                shl     eax, 8
                shld    ebx, eax, 5
                shl     eax, 8
                shld    ebx, eax, 5
                mov     [edi], bx
                add     edi, 2
                loop    @@loop
                ret
endp

proc            C32_16
@@loop:         mov     eax, [esi]
                add     esi, 4
                shl     eax, 8
                shld    ebx, eax, 5
                shl     eax, 8
                shld    ebx, eax, 6
                shl     eax, 8
                shld    ebx, eax, 5
                mov     [edi], bx
                add     edi, 2
                loop    @@loop
                ret
endp

proc            C32_24
                ret
endp






;;
;                               PALETTE                                    ;
;;

DBG_RUS_MESSAGE cErrNotPalette  "ꥪ  ਭ  'Palette'."
DBG_ENG_MESSAGE cErrNotPalette  "Object is not a 'Palette'."



proc            PaletteNew
                ;in
                ;  nothing
                ;out
                ;  edi - 'Palette'
                mov     eax, size palette
                call    HeapAlloc
                mov     [(palette edi).dSign], PALETTE_SIGN
                ret
endp



proc            PaletteDelete
                ;in
                ;  esi - 'Palette'
                ;out
                ;  nothing
                IF DBG
                  call  PaletteCheck
                ENDIF
                mov     eax, esi
                call    HeapFree
		ret
endp



IF DBG
proc            PaletteCheck
                ;in
                ;  esi - 'Palette'
                ;out
                ;  nothing
                cmp     [(palette esi).dSign], PALETTE_SIGN
                @IF_NE
                  lea   esi, [cErrNotPalette]
                  call  ErrorFatal
                @ENDIF
                ret
endp
ENDIF



proc            PaletteAssign
                ;in
                ;  esi - 'Palette'
                ;out
                ;  nothing
                ;description
                ;  Assigns palette to system palette and to video card.
                pushad

                IF DBG
                  call  PaletteCheck
                ENDIF

                mov     ecx, 256
                lea     esi, [(palette esi).adRGB]
                lea     edi, [adSystemPalette]
                rep     movsd

                call    SystemPaletteAssign

                popad
                ret
endp



proc            PaletteAssignRange
                ;in
                ;  eax - first color number (0 is minimal)
                ;  ebx - number of colors to set
                ;  esi - 'Palette'
                ;out
                ;  nothing
                ;description
                ;  Assigns part of palette to system palette and
                ;  to video card.
                pushad

                IF DBG
                  call  PaletteCheck
                ENDIF

                mov     ecx, ebx
                shl     eax, 2
                lea     esi, [(palette esi).adRGB]
                add     esi, eax
                lea     edi, [adSystemPalette]
                add     edi, eax
                rep     movsd

                call    SystemPaletteAssign

                popad
                ret
endp





;;
;                              SYSTEM PALETTE                              ;
;;
; Specification:                                                           ;
;   Array of 4-byte values (blue[+0], green[+1], red[+2], 0[+3]).          ;
;   Each component range from 0 to 255.                                    ;
;;

adSystemPalette db      256*4 dup (0)



proc            SystemPaletteGetColor
                ;in
                ;  eax - color number
                ;out
                ;  ebx - red
                ;  ecx - green
                ;  edx - blue
                push    esi
                lea     esi, [adSystemPalette]

                mov     ebx, [esi+eax*4]
                mov     ecx, ebx
                mov     edx, ebx

                and     ebx, 0FFh
                shr     ecx, 8
                and     ecx, 0FFh
                shr     edx, 16
                and     edx, 0FFh

                pop     esi
                ret
endp



proc            SystemPaletteSetColor
                ;in
                ;  eax - color number
                ;  ebx - red
                ;  ecx - green
                ;  edx - blue
                ;out
                ;  nothing
                push    esi

                lea     esi, [adSystemPalette+eax*4]

                mov     eax, edx
                shl     eax, 8
                or      eax, ecx
                shl     eax, 8
                or      eax, ebx
                mov     [esi], eax

                pop     esi
                ret
endp



abRawPalette    db      784 dup (250)
proc            SystemPaletteAssign
                ;in
                ;  nothing
                ;out
                ;  nothing
                ;description
                ;  Assigns system palette to video card.
                pushad

                xor     ebx, ebx
                lea     edi, [abRawPalette]
@@loop:         mov     eax, [dptr ebx+adSystemPalette]
                add     ebx, 4
                shr     eax, 2
                and     eax, 03F3F3Fh
                mov     [edi], eax
                add     edi, 3
                cmp     ebx, 4*256
                jb      @@loop

                lea     esi, [abRawPalette]
                call    VgaSetPalette

                popad
                ret
endp



proc            SystemPaletteToCdf
                ;in
                ;  esi - Cdf file
                ;out
                ;  nothing
                ;description
                ;  Writes palette to opened Cdf file.
                push    edi

                IF DBG
                  call  CdfCheck
                ENDIF

                mov     eax, CDFB_SYSTEM_PALETTE
                call    CdfBeginWriteBlock

                mov     eax, 256*4
                lea     edi, [adSystemPalette]
                call    CdfWriteStr

                call    CdfEndWriteBlock

                pop     edi
                ret
endp



proc            SystemPaletteFromCdf
                ;in
                ;  esi - Cdf file
                ;out
                ;  nothing
                ;description
                ;  Reads palette from opened Cdf file.
                push    edi

                IF DBG
                  call  CdfCheck
                ENDIF

                call    CdfBeginReadBlock
                cmp     eax, CDFB_SYSTEM_PALETTE
                @IF_E
                  mov   eax, 256*4
                  lea   edi, [adSystemPalette]
                  call  CdfReadStr
                @ENDIF
                call    CdfEndReadBlock

                pop     edi
                ret
endp

ends            code32
                end
