;*****
; cdfb.asm - CDF blocks for reading and writing 'PIC' object.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __CDFB__ equ 1
                include "pmlib.asd"
                include "cdfb.asi"
                include "cdf.asi"
                include "color.asi"
                include "debug.asi"
                include "error.asi"
                include "heap.asi"
                include "pic.asi"



CDFB_PIC        equ     0       ;code for 'PIC' block
CDFB_PIC_HDR    equ     0       ;code for 'HRD' subblock
CDFB_PIC_PAL    equ     1       ;code for 'PAL' subblock
CDFB_PIC_DATA   equ     2       ;code for 'DATA' subblock



struc           pic_hdr
  dTotalRow     dw      0
  dTotalCol     dw      0
  dBytesPerCell db      0
ends



RUS_MESSAGE     cErrHdrNotFirst "   ."
ENG_MESSAGE     cErrHdrNotFirst "Header must be first."
RUS_MESSAGE     cErrPal         "   ন."
ENG_MESSAGE     cErrPal         "Palette not supported yet."
RUS_MESSAGE     cErrColorDepth  "⭠ 㡨 梥."
ENG_MESSAGE     cErrColorDepth  "Unknown color depth."
RUS_MESSAGE     cErrDataExpect  " ."
ENG_MESSAGE     cErrDataExpect  "Data expected."



struc           locals
  dPicHdr       dd      0
  dPalette      dd      0
  dPic          dd      0
ends
proc            CdfbPicRead
                ;in
                ;  esi - CDF
                ;out
                ;  edi=0 - error, unknown block code
                ;  edi#0 - new 'PIC' object handle
                push    ebx ecx edx esi ebp
                sub     esp, size locals
                mov     ebp, esp

                ;;check block code
                call    CdfPreReadBlock
                cmp     eax, CDFB_PIC
                @IF_NE
                  xor   edi, edi
                  jmp   @@exit
                @ENDIF
                call    CdfBeginReadBlock

                ;;allocate memory for header
                mov     eax, size pic_hdr
                call    HeapAlloc
                mov     [(locals ebp).dPicHdr], edi

                ;;read header
                call    CdfBeginReadBlock
                cmp     eax, CDFB_PIC_HDR
                @IF_NE
                  lea   esi, [cErrHdrNotFirst]
                  call  ErrorFatal
                @ENDIF
                mov     eax, size pic_hdr
                mov     edi, [(locals ebp).dPicHdr]
                call    CdfReadStr
                call    CdfEndReadBlock

                ;;read palette
                mov     [(locals ebp).dPalette], 0
                call    CdfPreReadBlock
                cmp     eax, CDFB_PIC_PAL
                @IF_E
                  lea   esi, [cErrPal]
                  call  ErrorFatal
                @ENDIF

                ;;create 'PIC' object
                mov     edi, [(locals ebp).dPicHdr]
                movzx   eax, [(pic_hdr edi).dTotalRow]
                movzx   ebx, [(pic_hdr edi).dTotalCol]
                mov     cl, [(pic_hdr edi).dBytesPerCell]
                cmp     cl, 1
                @IF_NE
                  lea   esi, [cErrColorDepth]
                  call  ErrorFatal
                @ELSE
                  mov   ecx, COLOR8
                @ENDIF
                call    PicNew
                mov     [(locals ebp).dPic], edi

                ;;read data
                call    CdfBeginReadBlock
                cmp     eax, CDFB_PIC_DATA
                @IF_NE
                  lea   esi, [cErrDataExpect]
                  call  ErrorFatal
                @ENDIF
                mov     edi, [(locals ebp).dPic]
                mov     eax, [(pic edi).dTotalRow]
                mul     [(pic edi).dTotalCol]
                mul     [(pic edi).dBytesPerCell]
                mov     edi, [(pic edi).dImagePtr]
                call    CdfReadStr
                call    CdfEndReadBlock

                ;;free header memory
                mov     eax, [(locals ebp).dPicHdr]
                call    HeapFree

                call    CdfEndReadBlock

                ;;return 'PIC' handle
                mov     edi, [(locals ebp).dPic]

@@exit:         add     esp, size locals
                pop     ebp esi edx ecx ebx
                ret
endp



proc            CdfbPicWrite
                ;in
                ;  esi - CDF
                ;  edi - 'PIC' object descriptor
                ;out
                ;  nothing
                pushad
                mov     ebx, edi

                mov     eax, size pic_hdr
                call    HeapAlloc
                mov     ecx, edi

                mov     eax, [(pic ebx).dTotalRow]
                mov     [(pic_hdr edi).dTotalRow], ax
                mov     eax, [(pic ebx).dTotalCol]
                mov     [(pic_hdr edi).dTotalCol], ax
                mov     eax, [(pic ebx).dBytesPerCell]
                mov     [(pic_hdr edi).dBytesPerCell], al

                mov     eax, CDFB_PIC
                call    CdfBeginWriteBlock

                mov     eax, CDFB_PIC_HDR
                call    CdfBeginWriteBlock
                mov     eax, size pic_hdr
                call    CdfWriteStr
                call    CdfEndWriteBlock

                mov     eax, [(pic ebx).dColorScheme]
                cmp     eax, COLOR88
                @IF_E
                  mov   eax, CDFB_PIC_PAL
                  call  CdfBeginWriteBlock
                  mov   eax, 256*4
                  mov   edi, [(pic ebx).dPalette]
                  lea   edi, [(palette edi).adRGB]
                  call  CdfWriteStr
                  call  CdfEndWriteBlock
                @ENDIF

                mov     eax, CDFB_PIC_DATA
                call    CdfBeginWriteBlock
                mov     eax, [(pic ebx).dTotalRow]
                mul     [(pic ebx).dTotalCol]
                mul     [(pic ebx).dBytesPerCell]
                mov     edi, [(pic ebx).dImagePtr]
                call    CdfWriteStr
                call    CdfEndWriteBlock

                call    CdfEndWriteBlock

                mov     eax, ecx
                call    HeapFree

                popad
                ret
endp

ends            code32
                end
