;*****
; pmlib.asd - common definitions.
;



off             equ     offset
dptr            equ     dword ptr
wptr            equ     word ptr
bptr            equ     byte ptr





;****************************************************************************;
;                         MULTILINGUAL SUPPORT                               ;
;****************************************************************************;

;               RUSSIAN equ 1           ;select russian language
                ENGLISH equ 1           ;select english language

macro           RUS_MESSAGE     VarName, cText
IFDEF           RUSSIAN
  &VarName      db      &cText, 0
ENDIF
endm

macro           ENG_MESSAGE     VarName, cText
IFDEF           ENGLISH
  &VarName      db      &cText, 0
ENDIF
endm





;****************************************************************************;
;                               USEFUL MACROS                                ;
;****************************************************************************;

macro           @MIN    reg1, reg2
                local   @@cont
                cmp     &reg1, &reg2
                jb      @@cont
                  mov   &reg1, &reg2
                @@cont:
endm

macro           @MAX    reg1, reg2
                local   @@cont
                cmp     &reg1, &reg2
                ja      @@cont
                  mov   &reg1, &reg2
                @@cont:
endm





;****************************************************************************;
;                            RUNTIME DEBUGGING                               ;
;****************************************************************************;

DBG             equ     1       ;1=On, 0=Off

macro           DBG_RUS_MESSAGE VarName, cText
IF              DBG
                RUS_MESSAGE     VarName, cText
ENDIF
endm

macro           DBG_ENG_MESSAGE VarName, cText
IF              DBG
                ENG_MESSAGE     VarName, cText
ENDIF
endm

macro           @ERROR_C        VarName
                local   @@cont
                jnc     @@cont
                  lea   esi, [&VarName]
                  call  ErrorFatal
                @@cont:
endm

macro           @ERROR_NE       VarName
                local   @@cont
                je      @@cont
                  lea   esi, [&VarName]
                  call  ErrorFatal
                @@cont:
endm





;****************************************************************************;
;                           CONDITIONAL BRANCHES                             ;
;****************************************************************************;

if_level        =       0
if_count        =       0
if_count_next   =       0

macro           @IF_JUMP        instruction, count
                &instruction    @@if_&count
endm

macro           @IF_LABEL       count
                @@if_&count&:
endm

macro           @IF_SAVE_COUNT  level
                if_count_&level = if_count
endm

macro           @IF_REST_COUNT  level
                if_count = if_count_&level
endm

macro           @IF_Z
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jnz>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_NZ
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jz>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_C
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jnc>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_NC
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jc>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_S
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jns>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_NS
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <js>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_E
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jne>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_NE
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <je>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_B
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jnb>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_NB
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jb>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_BE
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jnbe>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_A
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jna>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_NA
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <ja>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @IF_AE
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_JUMP        <jnae>, %if_count
                @IF_SAVE_COUNT  %if_level
                if_level        = if_level + 1
endm

macro           @ELSE
                @IF_JUMP        <jmp>, %if_count_next
                @IF_REST_COUNT  %(if_level-1)
                @IF_LABEL       %if_count
                if_count        = if_count_next
                if_count_next   = if_count_next + 1
                @IF_SAVE_COUNT  %(if_level-1)
endm

macro           @ENDIF
                if_level        = if_level - 1
                @IF_REST_COUNT  %if_level
                @IF_LABEL       %if_count
endm



;****************************************************************************;
;                                  LOOP                                      ;
;****************************************************************************;

djnz_level      =       0
djnz_count      =       0
djnz_count_next =       0

macro           @DJNZ_JUMP      count
                jnz             short   djnz_&count
endm

macro           @DJNZ_LABEL     count
                djnz_&count&:
endm

macro           @DJNZ_SAVE_COUNT level
                djnz_count_&level = djnz_count
endm

macro           @DJNZ_REST_COUNT level
                djnz_count = djnz_count_&level
endm

macro           @DO
                djnz_count      = djnz_count_next
                djnz_count_next = djnz_count_next + 1
                @DJNZ_LABEL     %djnz_count
                @DJNZ_SAVE_COUNT %djnz_level
                djnz_level      = djnz_level + 1
endm

macro           @DJNZ           reg
                djnz_level      = djnz_level - 1
                @DJNZ_REST_COUNT %djnz_level
                dec     &reg
                @DJNZ_JUMP      %djnz_count
endm
