;*****
; array.asm - array object
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __ARRAY__ equ 1
                include "pmlib.asd"
                include "array.asi"
                include "heap.asi"



struc           array
  dFirst        dd      0       ;first element number
  dLast         dd      0       ;last element number
  dFirstPtr     dd      0       ;pointer to first element
ends



proc            ArrayNew
                ;in
                ;  eax - first element number
                ;  ebx - last element number
                ;out
                ;  esi - pointer to array
                ;description
                ;  Array constructor.
                push    edx edi

                mov     edx, eax
                mov     eax, size array
                call    HeapAlloc
                mov     esi, edi

                mov     [(array esi).dFirst], edx
                mov     [(array esi).dLast], ebx

                mov     eax, ebx
                sub     eax, edx
                inc     eax
                shl     eax, 2
                call    HeapAlloc
                mov     [(array esi).dFirstPtr], edi

                pop     edi edx
                ret
endp



proc            ArrayDelete
                ;in
                ;  esi - pointer to array
                ;out
                ;  nothing
                ;description
                ;  Array destructor.
                mov     eax, [(array esi).dFirstPtr]
                call    HeapFree
                mov     eax, esi
                call    HeapFree
                ret
endp



proc            ArrayBounds
                ;in
                ;  esi - pointer to array
                ;out
                ;  eax - first element number
                ;  ebx - last element number
                ;description
                ;  Returns array bounds.
                mov     eax, [(array esi).dFirst]
                mov     ebx, [(array esi).dLast]
                ret
endp



proc            ArrayElementInsert
                ;in
                ;  eax - position
                ;  esi - array pointer
                ;  edi - element
                ;out
                ;  nothing
                ;description
                ;  Inserts element into array at selected position.
                bound   eax, [esi]
                push    ebx
                mov     ebx, [(array esi).dFirstPtr]
                sub     eax, [(array esi).dFirst]
                mov     [ebx+eax*4], edi
                pop     ebx
                ret
endp



proc            ArrayElementRetrive
                ;in
                ;  eax - position
                ;  esi - array pointer
                ;out
                ;  edi - element
                ;description
                ;  Returns element from selected position of array.
                bound   eax, [esi]
                mov     edi, [(array esi).dFirstPtr]
                sub     eax, [(array esi).dFirst]
                mov     edi, [edi+eax*4]
                ret
endp

ends            code32
                end
