;*****
; api.asm  -  Application program interface (not a good name but this module
;             have unique functions).
;



                extrn   _pm_info:far
                extrn   _pm_init:far



STACKLEN        = 80h

union           lb      ;buffer in the conventional (low) memory
  abLowBuffer   db      4*1024 dup (?)
  struc
    cErr1       db      'Not enough low memory!',13,10,36
    cErr2       db      '80386 or better not detected!',13,10,36
    cErr3       db      'System already in protected mode and no VCPI or DPMI found!',13,10,36
    cErr4       db      'DPMI host is not 32bit!',13,10,36
    cErr5       db      'Could not enable A20 gate!',13,10,36
    cErr6       db      'Could not enter DPMI 32bit protected mode!',13,10,36
    cErr7       db      'Could not allocate needed DPMI selectors!',13,10,36
  ends
ends




segment         code16 public use16 'CODE'
                assume  cs:code16, ds:code16

start_fail:     ;;ax - error code
                mov     bx, ax
                mov     ax, code32
                mov     es, ax
                mov     ds, ax
                lea     di, [uLowBuffer]
                mov     ax, 0924h
loop1:          dec     bx
                js      print
                mov     cx, ax          ;to be longer then message length
                repne   scasb
                jmp     loop1
print:          mov     dx, di
                int     21h
exit:           mov     ax, 4cffh
                int     21h

start16:        ;;execution starts here
                push    cs
                pop     ds

                call    _pm_info
                jc      short start_fail

                ;;check low memory quantity
                mov     dx, [es:[2]]            ;next segment after program
                mov     cx, ss
                add     cx, STACKLEN            ;cx-program end
                add     cx, bx                  ;cx-free memory start
                sub     dx, cx
                mov     ax, 0                   ;error code
                jb      start_fail

                push    cx                      ;free memory start
                push    dx                      ;free memory length
                sub     cx, bx
                mov     es, cx                  ;value for _pm_init

                ;;enter to protected mode
                call    _pm_init
                jc      start_fail
                push    es                      ;PSP selector

                ;;create flat memory selector
                mov     ax, 0CF92h
                xor     ebx, ebx
                mov     ecx, ebx
                dec     ecx
                call    ApiCreateDescriptor
                jc      exit
                push    ax                      ;flat memory selector

                ;;create selector for application program data
                mov     ax, 0CF92h
                mov     bx, code32
                shl     ebx, 4
                push    ebx                     ;dBaseAddr
                call    ApiCreateDescriptor
                jc      exit
                push    ax                      ;data selector

                ;;create selector for application program code
                mov     ax, 0CF9Ah
                call    ApiCreateDescriptor
                jc      exit

                pop     dx      ;data selector
                pop     ebx     ;dBaseAddr
                pop     si      ;flat memory selector
                pop     di      ;PSP selector
                pop     ecx     ;length and start of free conventional memory

                ;;enter 32-bit segment
                push    ax
                push    off start32
                db      66h
                retf



proc            ApiCreateDescriptor
                ;in
                ;  ax  - access rights
                ;  ebx - base address
                ;  ecx - segment limit
                ;out
                ;  ax  - selector of created descriptor
                push    ebx ecx edx esi edi

                mov     dx, ax
                mov     esi, ebx
                mov     edi, ecx

                ;;set descriptor's access rights equal to access rights
                ;;of application code
                mov     bx, cs
                lar     cx, bx
                and     ch, 60h
                or      dl, ch

                ;;create descriptor
                xor     ax, ax
                mov     cx, 1
                int     31h
                jc      @@exit
                mov     bx, ax

                ;;set access rights
                mov     ax, 0009h
                mov     cx, dx
                int     31h
                jc      @@exit

                ;;set base address
                mov     ax, 0007h
                shld    ecx, esi, 16
                mov     dx, si
                int     31h
                jc      @@exit

                ;;set size
                mov     ax, 0008h
                shld    ecx, edi, 16
                mov     dx, di
                int     31h
                mov     ax, bx

@@exit:         pop     edi esi edx ecx ebx
                ret
endp

ends



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __API__ equ     1
                include "pmlib.asd"
                include "api.asi"
                include "error.asi"
                include "str.asi"
                extrn   ErrorInit:proc
                extrn   LmInit:proc
                extrn   HeapInit:proc
                extrn   HeapRestore:proc
                extrn   Main:proc



uLowBuffer      lb      <>
wLowBufferSeg   dw      0
wLowBufferOff   dw      0
sVregs          vr      <>
dBaseAddr       dd      0

start32:        ;;set segment registers
                mov     ds, dx
                mov     es, dx
                mov     [dBaseAddr], ebx
                mov     fs, si                  ;flat memory selector
                mov     gs, di                  ;PSP selector

                ;;initialise low memory management system
                movzx   eax, cx
                shl     eax, 4                  ;low memory size
                xor     cx, cx
                shr     ecx, 12
                sub     ecx, ebx                ;low memory start
                call    LmInit

                ;;set variables
                lea     eax, [uLowBuffer]
                add     eax, [dBaseAddr]
                mov     ebx, eax
                and     bx, 0Fh
                shr     eax, 4
                mov     [wLowBufferSeg], ax
                mov     [wLowBufferOff], bx

                ;;initialise error handling system
                mov     eax, esp
                call    ErrorInit

                ;;initialise Heap
                call    HeapInit

                ;;call application main function
                call    Main

                ;;deinitialise Heap
                call    HeapRestore

                ;;leave protected mode and exit from program
                mov     ax, 4c00h
                int     21h
                ret
endp



proc            ApiStrToLowBuffer
                ;in
                ;  esi - pointer to Str
                ;out
                ;  edi - pointer to 0 after Str in low buffer
                push    ecx esi
                IF DBG
                  call  StrCheck
                ENDIF
                cld
                mov     ecx, [(str esi).dLength]
                mov     esi, [(str esi).dDataPtr]
                lea     edi, [uLowBuffer]
                rep     movsb
                mov     [edi], cl
                pop     esi ecx
                ret
endp



proc            ApiStrzToLowBuffer
                ;in
                ;  esi - pointer to Strz
                ;out
                ;  esi - pointer to 0 after Str
                ;  edi - pointer to 0 after Str in low buffer
                push    eax
                cld
                lea     edi, [uLowBuffer]
@@loop1:        lodsb
                stosb
                and     al, al
                jnz     @@loop1
                pop     eax
                ret
endp



RUS_MESSAGE     cErrInt31Fail   "訡  맮 INT 31h."
ENG_MESSAGE     cErrInt31Fail   "Error in INT 31h."

proc            ApiInt21h
                mov     [sVregs.eax], eax
                mov     [sVregs.ebx], ebx
                mov     [sVregs.ecx], ecx
                mov     [sVregs.edx], edx
                mov     [sVregs.esi], esi
                mov     [sVregs.edi], edi
                mov     [sVregs.ds], bp
                mov     eax, 300h               ;real mode call
                mov     ebx, 21h                ;int 21h
                xor     ecx, ecx                ;no parameters on stack
                mov     [sVregs.spss], ecx      ;PMODE will provide stack
                lea     edi, [sVregs]
                int     31h
                @IF_C
                  lea   esi, [cErrInt31Fail]
                  call  ErrorFatal
                @ENDIF

                ;test    [sVregs.flags], 1       ;CARRY_FLAG
                ;@IF_NZ
                ;  stc
                ;@ENDIF
                push    [sVregs.flags]
                popf

                mov     eax, [sVregs.eax]
                mov     ebx, [sVregs.ebx]
                mov     ecx, [sVregs.ecx]
                mov     edx, [sVregs.edx]
                mov     esi, [sVregs.esi]
                mov     edi, [sVregs.edi]
                ret
endp

ends            code32



segment         st_seg  public stack use16 'STACK'
                db      STACKLEN*10h dup(?)
ends            st_seg

                end     start16
