//******************************************************************************
// PLC: TOOLS                                   Copyright 1998 Adept Software **
//******************************************************************************

#ifndef PLC_TOOL_H
#define PLC_TOOL_H

#include "Adept.H"
#include "PLC_Main.H"

//******************************************************************************
//******************************************************************************
// INTERFACE

#define PLC_STORAGE_POINTER_MAX		100
#define PLC_ENVIR_MIN				20
#define PLC_TOKEN_MIN				50
#define PLC_DATATYPE_MIN			20
#define PLC_VARIABLE_MIN			30
#define PLC_ROUTINE_MIN				20
#define PLC_SYMBOL_MIN				50

// ERROR SYSTEM

enum
{
	PLC_STATE_NONE,
	PLC_STATE_COMPILING,
	PLC_STATE_EXECUTING,
	PLC_STATE_CUSTOM,
};

enum PLC_ERR_VALUE
{
	PLC_ERR_FATAL,

	PLC_ERR_LIMIT_EXCEEDED_s_i,
	PLC_ERR_OUT_OF_s,
	PLC_ERR_UNEXPECTED_EOB,

	PLC_ERR_ERROR_s,

	PLC_ERR_SYNTAX,PLC_ERR_SYNTAXNEAR_s,
	PLC_ERR_EXPECTING_SYMBOL,
	PLC_ERR_EXPECTING_s,
	PLC_ERR_EXPECTING_ITEM_s,
	PLC_ERR_EXPECTING_TYPE_s,
	PLC_ERR_UNKNOWN_SYMBOL_s,
	PLC_ERR_UNKNOWN_LABEL_s,
	PLC_ERR_UNKNOWN_ROUTINE_s,
	PLC_ERR_SYMBOL_EXISTS_s,
	PLC_ERR_PARM_WRONGNUM,PLC_ERR_PARMS,
	PLC_ERR_ILLEGAL_OPERATION,
	PLC_ERR_ILLEGAL_ASSIGNMENT,
	PLC_ERR_INVALID_COMPARISON,
	PLC_ERR_UNKNOWN_CHARACTER,
	PLC_ERR_STRING_TOO_LONG,
	PLC_ERR_DIV_ZERO,
	PLC_ERR_INVALID_DATATYPE,
	PLC_ERR_INVALID_TOKEN,
	PLC_ERR_VARIABLE_REFERENCED_s,

	PLC_ERR_WARNING_s,
};

//******************************************************************************
//******************************************************************************
// GLOBAL VARIABLES

#undef GLOBAL
#ifdef PLC_TOOL_C
	#define GLOBAL
#else
	#define GLOBAL	extern
#endif

GLOBAL	byte		PLC_ErrState;

//******************************************************************************
//******************************************************************************
// GLOBAL ROUTINES

void	PLC_Err					(PLC_ERR_VALUE ErrVal,...);

PLC_ENVIR		*PLC_EnvirSpawn		(void);
void			PLC_EnvirDestroy	(PLC_ENVIR *Envir);
void			PLC_EnvirInit		(PLC_ENVIR *Envir,PLC_ENVIR *Parent);
void			PLC_EnvirExecClear	(PLC_ENVIR *Envir);

PLC_TOKEN		*PLC_TokenSpawn		(LNK_LINK *TokenList,byte Type);
void			PLC_TokenDestroy	(PLC_TOKEN *Token);

PLC_DATATYPE	*PLC_DataTypeSpawn	(byte Type);
void			PLC_DataTypeDestroy	(PLC_DATATYPE *DataType);

// variables are only created during execution, because local symbols may reference variables from a different scope
PLC_VARIABLE	*PLC_VariableSpawn	(PLC_SYMBOL *Symbol);
void			PLC_VariableDestroy	(PLC_VARIABLE *Variable);
PLC_VARIABLE	*PLC_VariableSearch	(PLC_SYMBOL *Symbol,bool SearchParent);

PLC_ROUTINE		*PLC_RoutineSpawn	(PLC_SYMBOL *Symbol);
void			PLC_RoutineDestroy	(PLC_ROUTINE *Routine);
PLC_ROUTINE		*PLC_RoutineSearch	(PLC_SYMBOL *Symbol,bool SearchParent);

PLC_SYMBOL		*PLC_SymbolSpawn	(char *Name,sdword NameLen);
void			PLC_SymbolDestroy	(PLC_SYMBOL *Symbol);
PLC_SYMBOL		*PLC_SymbolSearch	(char *Name,sdword NameLen,bool SearchParent);

//******************************************************************************
//******************************************************************************
#endif
