//******************************************************************************
// PLC: DATA TYPES                              Copyright 1998 Adept Software **
//******************************************************************************

#define PLC_DT_C
#include "PLC_DT.H"
#include "PLC_Tool.H"

//**************************************
// INTERFACE

#define PLC_DT_INT_(DataType)		( ((sdword*)(DataType)->Data)[0] )
#define PLC_DT_FLOAT_(DataType)		( ((float*)(DataType)->Data)[0] )
#define PLC_DT_STRING_(DataType)	( ((char**)(DataType)->Data)[0] )

//**************************************
// LOCAL VARIABLES

//******************************************************************************
//******************************************************************************
// LOCAL ROUTINES

//******************************************************************************
//******************************************************************************
// PUBLIC ROUTINES

// the source buffer points to a datatype.  Determine which type, and tokenize it
void	PLC_DT_Tokenize		(LNK_LINK *Anchor)
{
	PLC_TOKEN		*Token;
	PLC_DATATYPE	*DataType;
	sdword			StrPos;
	char			*StringPtr,*TempPtr;
	byte			Radix=PLC_DT_DEFAULTRADIX;

	// new datatype
	if(PLC_SourceBuf[0]==PLC_Common.StringOpen[0])
	{
		// STRING
		PLC_SourceBuf++;
		DataType=PLC_DataTypeSpawn(PLC_DT_STRING);
		StringPtr=PLC_DT_GetString(DataType);
		StrPos=0;
		while(PLC_SourceBuf[0]!=PLC_Common.StringClose[0])
		{
			if(StrPos==PLC_DT_STRING_MAX) PLC_Err(PLC_ERR_STRING_TOO_LONG);
			if(PLC_SourceBuf[0]=='\\')
			{
				PLC_SourceBuf++;
				switch(toupper(PLC_SourceBuf[0]))
				{
				case 'N' :	StringPtr[StrPos++]='\n'; PLC_SourceBuf++;	break;
				case 'T' :	StringPtr[StrPos++]='\t'; PLC_SourceBuf++;	break;
				case '\\' :	StringPtr[StrPos++]='\\'; PLC_SourceBuf++;	break;
				default:	StringPtr[StrPos++]=PLC_SourceBuf[0];	break;
				}
				
			}
			else
			{
				PLC_DT_GetString(DataType)[StrPos++]=PLC_SourceBuf[0];
				PLC_SourceBuf++;
			}
		}
		StringPtr[StrPos]=0;
		PLC_SourceBuf++;
	}
	else
	{
		// NUMBER
		if(PLC_SourceBuf[strspn(PLC_SourceBuf,PLC_Common.Number)]=='.')
		{
			DataType=PLC_DataTypeSpawn(PLC_DT_FLOAT);
			PLC_DT_SetFloat(DataType,(float)strtod(PLC_SourceBuf,&TempPtr));
			PLC_SourceBuf=TempPtr;
		}
		else
		{
			DataType=PLC_DataTypeSpawn(PLC_DT_INT);
			if(PLC_SourceBuf[0]=='0' && toupper(PLC_SourceBuf[1])=='X')
			{
				PLC_SourceBuf+=2;
				Radix=16;
			}
			PLC_DT_SetInt(DataType,strtol(PLC_SourceBuf,&TempPtr,Radix));
			PLC_SourceBuf=TempPtr;
		}
	}
	// new token
	Token=PLC_TokenSpawn(Anchor,PLC_TT_DATATYPE);
	PLC_TOK_Pointer(Token)=DataType;
}

//******************************************************************************

void	PLC_DT_Init			(PLC_DATATYPE *DataType,byte Type)
{
	DataType->Type=Type;
	switch(DataType->Type)
	{
	case PLC_DT_NONE: break;
	case PLC_DT_INT:
		PLC_DT_SetInt(DataType,0);
		break;
	case PLC_DT_FLOAT:
		PLC_DT_SetFloat(DataType,0);
		break;
	case PLC_DT_STRING:
		MEM_Alloc(&PLC_DT_STRING_(DataType),PLC_DT_STRING_MAX);
		PLC_DT_SetString(DataType,"");
		break;
/*
	case PLC_DT_COBOL:
		// search for cobol variable name
		// allocate DataType->Data to store value
		// OR use DataType->Data to point to cobol value
		break;
*/
	default:
		PLC_Err(PLC_ERR_INVALID_DATATYPE);
		break;
	}
}

//**************************************

void	PLC_DT_Destroy		(PLC_DATATYPE *DataType)
{
	switch(DataType->Type)
	{
	case PLC_DT_INT:
	case PLC_DT_FLOAT:
		break;
	case PLC_DT_STRING:
		// free string
		MEM_Free(&PLC_DT_STRING_(DataType));
		break;
/*
	case PLC_DT_COBOL:
		// free DataType->Data?
		break;
*/
	default:
		PLC_Err(PLC_ERR_INVALID_DATATYPE);
		break;
	}
	DataType->Type=PLC_DT_NONE;
}

//******************************************************************************

void	PLC_DT_Assign		(PLC_DATATYPE *Dest,PLC_DATATYPE *Source)
{
	if(Dest->Type==PLC_DT_NONE) PLC_DT_Init(Dest,Source->Type);
	switch(Dest->Type)
	{
	case PLC_DT_INT:
		PLC_DT_SetInt(Dest , PLC_DT_GetInt(Source));
		break;
	case PLC_DT_FLOAT:
		PLC_DT_SetFloat(Dest , PLC_DT_GetFloat(Source));
		break;
	case PLC_DT_STRING:
		PLC_DT_SetString(Dest , PLC_DT_GetString(Source));
		break;
	default:
		PLC_Err(PLC_ERR_INVALID_DATATYPE);
		break;
	}
}

//**************************************

sbyte	PLC_DT_Compare		(PLC_DATATYPE *Value1,PLC_DATATYPE *Value2)
{
	sbyte	Result=0;

	if(Value1->Type==PLC_DT_INT && Value2->Type==PLC_DT_INT)
	{
		if(PLC_DT_GetInt(Value1) > PLC_DT_GetInt(Value2)) Result=1;
		else if(PLC_DT_GetInt(Value1) < PLC_DT_GetInt(Value2)) Result=-1;
	}
	else if(Value1->Type==PLC_DT_FLOAT && Value2->Type==PLC_DT_FLOAT)
	{
		if(PLC_DT_GetFloat(Value1) > PLC_DT_GetFloat(Value2)) Result=1;
		else if(PLC_DT_GetFloat(Value1) < PLC_DT_GetFloat(Value2)) Result=-1;
	}
	else if(Value1->Type==PLC_DT_INT && Value2->Type==PLC_DT_FLOAT)
	{
		if((float)PLC_DT_GetInt(Value1) > PLC_DT_GetFloat(Value2)) Result=1;
		else if((float)PLC_DT_GetInt(Value1) < PLC_DT_GetFloat(Value2)) Result=-1;
	}
	else if(Value1->Type==PLC_DT_FLOAT && Value2->Type==PLC_DT_INT)
	{
		if(PLC_DT_GetFloat(Value1) > (float)PLC_DT_GetInt(Value2)) Result=1;
		else if(PLC_DT_GetFloat(Value1) < (float)PLC_DT_GetInt(Value2)) Result=-1;
	}
	else if(Value1->Type==PLC_DT_STRING && Value2->Type==PLC_DT_STRING)
	{
		Result=(sbyte)strcmp(PLC_DT_GetString(Value1),PLC_DT_GetString(Value2));
	}
	else PLC_Err(PLC_ERR_INVALID_COMPARISON);
	return Result;
}

//******************************************************************************
//******************************************************************************

bool	PLC_DT_GetBool		(PLC_DATATYPE *DataType)
{
	bool	Data;

	if(DataType->Type==PLC_DT_NONE && DataType->Symbol!=NULL) PLC_Err(PLC_ERR_VARIABLE_REFERENCED_s,DataType->Symbol->Name);
	switch(DataType->Type)
	{
	case PLC_DT_INT:
		Data=PLC_DT_INT_(DataType)!=0;
		break;
	case PLC_DT_FLOAT:
		Data=PLC_DT_FLOAT_(DataType)!=0;
		break;
	default:
		PLC_Err(PLC_ERR_EXPECTING_TYPE_s,"boolean");
		break;
	}
	return Data;
}

//**************************************

bool	PLC_DT_SetBool		(PLC_DATATYPE *DataType,bool Data)
{
	if(DataType->Type==PLC_DT_NONE) PLC_DT_Init(DataType,PLC_DT_INT);
	switch(DataType->Type)
	{
	case PLC_DT_INT:
		PLC_DT_INT_(DataType)=Data;
		break;
	case PLC_DT_FLOAT:
		PLC_DT_FLOAT_(DataType)=Data;
		break;
	default:
		PLC_Err(PLC_ERR_ILLEGAL_ASSIGNMENT);
		break;
	}
	return Data;
}

//******************************************************************************

sdword	PLC_DT_GetInt		(PLC_DATATYPE *DataType)
{
	sdword	Data;

	if(DataType->Type==PLC_DT_NONE && DataType->Symbol!=NULL) PLC_Err(PLC_ERR_VARIABLE_REFERENCED_s,DataType->Symbol->Name);
	switch(DataType->Type)
	{
	case PLC_DT_INT:
		Data=PLC_DT_INT_(DataType);
		break;
	case PLC_DT_FLOAT:
		Data=(sdword)PLC_DT_FLOAT_(DataType);
		break;
	default:
		PLC_Err(PLC_ERR_EXPECTING_TYPE_s,"integer");
		break;
	}
	return Data;
}

//**************************************

sdword	PLC_DT_SetInt		(PLC_DATATYPE *DataType,sdword Data)
{
	if(DataType->Type==PLC_DT_NONE) PLC_DT_Init(DataType,PLC_DT_INT);
	switch(DataType->Type)
	{
	case PLC_DT_INT:
		PLC_DT_INT_(DataType)=Data;
		break;
	case PLC_DT_FLOAT:
		PLC_DT_FLOAT_(DataType)=(float)Data;
		break;
	default:
		PLC_Err(PLC_ERR_ILLEGAL_ASSIGNMENT);
		break;
	}
	return Data;
}

//******************************************************************************

float	PLC_DT_GetFloat		(PLC_DATATYPE *DataType)
{
	float	Data;

	if(DataType->Type==PLC_DT_NONE && DataType->Symbol!=NULL) PLC_Err(PLC_ERR_VARIABLE_REFERENCED_s,DataType->Symbol->Name);
	switch(DataType->Type)
	{
	case PLC_DT_INT:
		Data=(float)PLC_DT_INT_(DataType);
		break;
	case PLC_DT_FLOAT:
		Data=PLC_DT_FLOAT_(DataType);
		break;
	default:
		PLC_Err(PLC_ERR_EXPECTING_TYPE_s,"float");
		break;
	}
	return Data;
}

//**************************************

float	PLC_DT_SetFloat		(PLC_DATATYPE *DataType,float Data)
{
	if(DataType->Type==PLC_DT_NONE) PLC_DT_Init(DataType,PLC_DT_FLOAT);
	switch(DataType->Type)
	{
	case PLC_DT_INT:
		PLC_DT_INT_(DataType)=(sdword)Data;
		break;
	case PLC_DT_FLOAT:
		PLC_DT_FLOAT_(DataType)=Data;
		break;
	default:
		PLC_Err(PLC_ERR_ILLEGAL_ASSIGNMENT);
		break;
	}
	return Data;
}

//******************************************************************************

char	*PLC_DT_GetString	(PLC_DATATYPE *DataType)
{
	char	*Data;

	if(DataType->Type==PLC_DT_NONE && DataType->Symbol!=NULL) PLC_Err(PLC_ERR_VARIABLE_REFERENCED_s,DataType->Symbol->Name);
	switch(DataType->Type)
	{
	case PLC_DT_STRING:
		Data=PLC_DT_STRING_(DataType);
		break;
	default:
		PLC_Err(PLC_ERR_EXPECTING_TYPE_s,"string");
		break;
	}
	return Data;
}

//**************************************

char	*PLC_DT_SetString	(PLC_DATATYPE *DataType,char *Data)
{
	if(DataType->Type==PLC_DT_NONE) PLC_DT_Init(DataType,PLC_DT_STRING);
	switch(DataType->Type)
	{
	case PLC_DT_STRING:
		strcpy(PLC_DT_STRING_(DataType),Data);
		break;
	default:
		PLC_Err(PLC_ERR_ILLEGAL_ASSIGNMENT);
		break;
	}
	return PLC_DT_STRING_(DataType);
}

//******************************************************************************
//******************************************************************************
