unit FAQ033F2;
//
// PixelGraphicLibrary - FAQ 33
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, StdCtrls, ExtCtrls;

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    PGImage1: TPGImage;
    procedure PGImage1PicBoxOnPaint(Sender: TObject);
    procedure PGImage1PicBoxOnMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    PaletteIndex: Integer;
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.PGImage1PicBoxOnPaint(Sender: TObject);
var aRect: TRect;
begin
aRect.left:=(PaletteIndex mod 16) * (PGImage1.PicBox.width - 1) div 16;
aRect.top:=(PaletteIndex div 16) * (PGImage1.PicBox.height - 1) div 16;
aRect.right:=((PaletteIndex mod 16) + 1) * (PGImage1.PicBox.width - 1) div 16 + 1;
aRect.bottom:=(PaletteIndex div 16 + 1) * (PGImage1.PicBox.height - 1) div 16 + 1;
PGImage1.PicBox.Canvas.Brush.Color:=clWhite;
PGImage1.PicBox.Canvas.Brush.Style:=bsSolid;
PGImage1.PicBox.Canvas.FrameRect(aRect);
end;

procedure TForm2.PGImage1PicBoxOnMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
   newPaletteIndex: Integer;
begin
newPaletteIndex:=(y*16 div PGImage1.PicBox.Height)*16 + x*16 div PGImage1.PicBox.Width;
if newPaletteIndex<PGImage1.LendNoModifyPixelGraphic.NumPaletteEntries then
   begin
   PaletteIndex:=newPaletteIndex;
   PGImage1.Invalidate;
   end;
end;

end.
