unit FAQ032F;
//
// PixelGraphicLibrary - FAQ 32
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, Buttons, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Saveas1: TMenuItem;
    Info1: TMenuItem;
    PGImage1: TPGImage;
    Print1: TMenuItem;
    CMYFilterDialog1: TCMYFilterDialog;
    Filter1: TMenuItem;
    CMY1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PGSaveDialog1: TPGSaveDialog;
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure CMY1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
PGOpenDialog1.Filename:=PGImage1.Filename;
if PGOpenDialog1.Execute then
   PGImage1.Filename:=PGOpenDialog1.Filename;
Saveas1.Enabled:=not PGImage1.Empty;
Print1.Enabled:=not PGImage1.Empty;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
PGSaveDialog1.Filename:=PGImage1.Filename;
if PGSaveDialog1.Execute then
   PGImage1.SaveToFile(PGSaveDialog1.Filename);             
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
PGImage1.LendPixelGraphic.Print(true, true, self);
end;

procedure TForm1.CMY1Click(Sender: TObject);
begin
if (not PGImage1.Empty) and CMYFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(CMYFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.Info1Click(Sender: TObject);
// Set application title and show the info-message
begin
Application.Title:=Caption;
ShowMessage(
   'Question: I would like to translate the filter dialogs to my '+
   'language. How can I do this?' + #13#13 +
   'Answer: Fill the Other fields of the PGLangStrEntries array with your '+
   'translations and set PGLanguage to pglOther. Have a look at the end of '+
   'the file PGraphic.int where you will find an array with the strings to translate. '+
   'You should do the translations in the initialization section of a unit '+
   'that uses PGraphic.' + #13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

Initialization
PGLangStrEntries[pgsiCMYFilter].Other:='My Super CMY Filter';
PGLangStrEntries[pgsiCLabel].Other:='c';
PGLangStrEntries[pgsiMLabel].Other:='m';
PGLangStrEntries[pgsiYLabel].Other:='y';
PGLangStrEntries[pgsiOKButton].Other:='My OK';
PGLangStrEntries[pgsiCancelButton].Other:='My Cancel';
PGLanguage:=pglOther;

end.
