unit FAQ031F;
//
// PixelGraphicLibrary - FAQ 31
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PGImage1: TPGImage;
    PGImage2: TPGImage;
    Timer1: TTimer;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
   PGImage2.TakePixelGraphicCopy(PGImage1.LendNoModifyPixelGraphic);
   end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
PGImage2.SetSelectionBounds(
   PGImage1.PicToGraphicX(PGImage1.HorzScrollBar.Position),
   PGImage1.PicToGraphicY(PGImage1.VertScrollBar.Position),
   PGImage1.PicToGraphicX(PGImage1.HorzScrollBar.Position+PGImage1.ClientWidth)-PGImage1.PicToGraphicX(PGImage1.HorzScrollBar.Position),
   PGImage1.PicToGraphicY(PGImage1.VertScrollBar.Position+PGImage1.ClientHeight)-PGImage1.PicToGraphicY(PGImage1.VertScrollBar.Position));
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: I have two TPGImages. I want to show on one of them the visible '+
   'portion of the other as a selection. I have to use the PicToGraphic '+
   'functions, but how can I determine the visible portion? Note: I am using the '+
   'sZoomKAR and sAlwaysKAR for the Stretch properties of the PGImages.'+#13#13+
   'Answer: Have a look at this...'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
