unit FAQ029F;
//
// PixelGraphicLibrary - FAQ 29
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    Save1: TMenuItem;
    PGSaveDialog1: TPGSaveDialog;
    Panel1: TPanel;
    Button1: TButton;
    PGImage1: TPGImage;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure PGImage1SelectionChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
   PGImage1.Selection:=false;
   end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImage1.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
   CropPG: TPixelGraphic;
   PGImagePG: TPixelGraphic;
   x, y: Integer;
begin
CropPG:=TPixelGraphic.Create;
try
   PGImagePG:=PGImage1.LendNoModifyPixelGraphic;
   CropPG.SetDimension(PGImage1.SelectionWidth, PGImage1.SelectionHeight, PGImagePG.BitCount);
   if PGImagePG.BitCount<>bc24 then
      CropPG.CopyPalette(PGImagePG);
   // note: It would be possible to use DrawRect or something like this, but this should be faster and result in better quality
   for y:=0 to PGImage1.SelectionHeight-1 do
      for x:=0 to PGImage1.SelectionWidth-1 do
         CropPG.Bits[x,y]:=PGImagePG.Bits[x+PGImage1.SelectionLeft,y+PGImage1.SelectionTop];
   PGImage1.Selection:=false;
   PGImage1.TakePixelGraphic(CropPG);
except
   CropPG.Free;
   raise;
end; // of try/finally
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: Do you have a demo showing how to crop a selected region of a PixelGraphic?'#13#13+
   'Answer: Here is an example. Load an image, select an area and press the crop button.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

procedure TForm1.PGImage1SelectionChange(Sender: TObject);
begin
Button1.Enabled:=PGImage1.Selection;
end;

end.
