unit FAQ027F;
//
// PixelGraphicLibrary - FAQ 27
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, StdCtrls, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    PGImage1: TPGImage;
    PrevSB: TSpeedButton;
    NextSB: TSpeedButton;
    Label1: TLabel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Info1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    Label2: TLabel;
    procedure Open1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure NextSBClick(Sender: TObject);
    procedure PrevSBClick(Sender: TObject);
    procedure Info1Click(Sender: TObject);
  private
    { Private declarations }
    GraphicCount: Integer;
    GraphicIndex: Integer;
    procedure UpdateLabelsAndButtons;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.UpdateLabelsAndButtons;
   begin
   Label1.Caption:='Number of graphics in file: '+IntToStr(GraphicCount);
   Label2.Caption:='Index of displayed graphic: '+IntToStr(GraphicIndex);
   NextSB.Enabled:=GraphicIndex<GraphicCount-1;
   PrevSB.Enabled:=(GraphicIndex>0) and (GraphicCount>0);
   end;

procedure TForm1.Open1Click(Sender: TObject);
var
   iType, iSubType, iOptions, iColors: string;
   iWidth, iHeight, iBitsPerPixel: Integer;
begin
if PGOpenDialog1.Execute then
   begin
   try
      GraphicCount:=0;
      GraphicIndex:=0;
      // Just find out how many graphics are in the file
      PGFileInfo(PGOpenDialog1.FileName, 0, iType, iSubType, iOptions, iWidth, iHeight, iColors, iBitsPerPixel, GraphicCount);
      // Load the first graphic in the file
      PGImage1.FileName:=PGOpenDialog1.FileName;
   finally
      UpdateLabelsAndButtons;
   end;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
TIFFReadMultipleImagesEnabled:=true;
UpDateLabelsAndButtons;
Info1Click(self);
end;

procedure TForm1.NextSBClick(Sender: TObject);
begin
try
   Inc(GraphicIndex);
   PGImage1.PixelGraphic.LoadFromFileIndex(PGImage1.FileName, GraphicIndex);
finally
   UpdateLabelsAndButtons;
end;
end;

procedure TForm1.PrevSBClick(Sender: TObject);
begin
try
   Dec(GraphicIndex);
   PGImage1.PixelGraphic.LoadFromFileIndex(PGImage1.FileName, GraphicIndex);
finally
   UpdateLabelsAndButtons;
end;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I load the single graphics from a multi image TIFF file?'#13#13 +
   'Answer: Use PGFileInfo to find out about the number of graphics included in a file and use TPixelGraphic.LoadFromFileIndex to load a single graphic from a multi image file. Open file FAQ027.TIF when running this application!'+#13#13+
   'Note: TIFFReadMultipleImagesEnabled is set to true in FormCreate. The PixelGraphicLibrary supports only the TIFF compression shemes Uncompressed and PackBits.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
