unit FAQ026F;
//
// PixelGraphicLibrary - FAQ 26
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, ExtCtrls, Menus;

type
  TForm1 = class(TForm)
    PGImage1: TPGImage;
    PaletteAnimationTimer: TTimer;
    MainMenu1: TMainMenu;
    animate1: TMenuItem;
    Info1: TMenuItem;
    Start1: TMenuItem;
    Settings1: TMenuItem;
    N1: TMenuItem;
    Size2: TMenuItem;
    MaxIterations1: TMenuItem;
    ShowProgress1: TMenuItem;
    StartTimer: TTimer;
    File1: TMenuItem;
    Saveas1: TMenuItem;
    N2: TMenuItem;
    Print1: TMenuItem;
    PGSaveDialog1: TPGSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure PGImage1SelectionMade(Sender: TObject);
    procedure PaletteAnimationTimerTimer(Sender: TObject);
    procedure animate1Click(Sender: TObject);
    procedure Start1Click(Sender: TObject);
    procedure ShowProgress1Click(Sender: TObject);
    procedure Size2Click(Sender: TObject);
    procedure MaxIterations1Click(Sender: TObject);
    procedure StartTimerTimer(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
  private
    { Private declarations }         
    CReMin, CReMax, CImMin, CImMax: Extended;
    procedure Start;
    procedure NewImage(ReMin, ReMax, ImMin, ImMax: Extended);
  public
    { Public declarations }
  end;

const
   Size: Integer = 200;
   ItMax: Integer = 250;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.NewImage(ReMin, ReMax, ImMin, ImMax: Extended);

   var
      aWidth: Integer;
      aHeight: Integer;
      x, y: Integer;
      CRe, CIm, ZRe, ZIm, ZRe2, ZIm2, OldZRe: Extended;
      It: Integer;
      PG: TPixelGraphic;
   begin
   CReMin:=ReMin;
   CReMax:=ReMax;
   CImMin:=ImMin;
   CImMax:=ImMax;
   PG:=PGImage1.PixelGraphic;
   with PG do
      begin
      if (ReMax-ReMin)>(ImMax-ImMin) then
         begin
         aWidth:=Size;
         aHeight:=round(Size*(ImMax-ImMin)/(ReMax-ReMin));
         end
      else
         begin
         aWidth:=round(Size*(ReMax-ReMin)/(ImMax-ImMin));
         aHeight:=Size;
         end;
      SetDimension(aWidth, aHeight, bc8);
      for y:=0 to aHeight do
         begin
         CIm:=CImMin+y/aHeight*(CImMax-CImMin);
         for x:=0 to aWidth do
            begin
            CRe:=CReMin+x/aWidth*(CReMax-CReMin);
            ZRe:=0;
            ZIm:=0;
            ZRe2:=0;
            ZIm2:=0;
            It:=0;
            while ((ZRe2+ZIm2)<16) and (It<ItMax) do
               begin
               OldZRe:=ZRe;
               ZRe:=ZRe2-ZIm2+CRe;
               ZIm:=2*OldZRe*ZIm+CIm;
               ZRe2:=sqr(ZRe);
               ZIm2:=sqr(ZIm);
               Inc(It)
               end;
            if (It<ItMax)then
               Bits[x,y]:= It mod (NumPaletteEntries-1)+1
            else
               Bits[x,y]:= 0;
            end;
         if ShowProgress1.Checked then
            begin
            PGImage1.Invalidate;
            PGImage1.Update;
            end;
         end;
      end; // of with
   PGImage1.Invalidate;
   PGImage1.Update;
   end;

procedure TForm1.FormCreate(Sender: TObject);
var
   aPG: TPixelGraphic;

   procedure FillPaletteEntries(Index1, Index2, R1, G1, B1, R2, G2, B2: Byte);
      var i: Integer;
      begin
      for i:=Index1 to Index2-1{!} do
         aPG.PaletteEntries[i]:=rgb(
            R1+(i-Index1)*(R2-R1) div (Index2-Index1),
            G1+(i-Index1)*(G2-G1) div (Index2-Index1),
            B1+(i-Index1)*(B2-B1) div (Index2-Index1)
            );
      end;

var
   ScreenDC: HDC;
   DCBitCount: Integer;

begin
Info1Click(Self);
ScreenDC:=GetDC(0);
try
   DCBitCount := (GetDeviceCaps(ScreenDC,BITSPIXEL) * GetDeviceCaps(ScreenDC, PLANES));
finally
   ReleaseDC(0, ScreenDC);
end; // of try/finally
if DCBitCount<8 then
   begin
   ShowMessage('This application requires a 256 color or true color system...');
   Application.Terminate;
   end;
aPG:=TPixelGraphic.Create;
aPG.BitCount:=bc8;
aPG.NumPaletteEntries:=235;
// Setting the PaletteAnimation property to true causes that no palette entries of other
// windows will mapped to the same entries in the system palette.
aPG.PaletteAnimation:=true;
// Fill the palette
aPG.PaletteEntries[0]:=0;
FillPaletteEntries(1,40,255,0,0,255,255,0);
FillPaletteEntries(40,79,255,255,0,0,255,0);
FillPaletteEntries(79,118,0,255,0,0,255,255);
FillPaletteEntries(118,157,0,255,255,0,0,255);
FillPaletteEntries(157,196,0,0,255,255,0,255);
FillPaletteEntries(196,235,255,0,255,255,0,0);
PGImage1.PixelGraphic:=aPG;
StartTimer.Enabled:=true;
PaletteAnimationTimer.Enabled:=true;
end;

procedure TForm1.Start;
begin
NewImage(-2,1,-1.5,1.5);
end;

procedure TForm1.PGImage1SelectionMade(Sender: TObject);
var
   aPG: TPixelGraphic;
begin
aPG:=PGImage1.LendNoModifyPixelGraphic;
PGImage1.Selection:=false;
NewImage(
    CReMin+PGImage1.SelectionLeft*(CReMax-CReMin)/aPG.Width,
    CReMin+(PGImage1.SelectionLeft+PGImage1.SelectionWidth)*(CReMax-CReMin)/aPG.Width,
    CImMin+PGImage1.SelectionTop*(CImMax-CImMin)/aPG.Height,
    CImMin+(PGImage1.SelectionTop+PGImage1.SelectionHeight)*(CImMax-CImMin)/aPG.Height);
end;

procedure TForm1.PaletteAnimationTimerTimer(Sender: TObject);
var i: Integer;
    PaletteEntry1: TRGB;
begin
// this does the animation
with PGImage1.PixelGraphic do
   begin
   BeginUpdate;
   try
      PaletteEntry1:=PaletteEntries[1];
      for i:= 1 to NumPaletteEntries-2 do
         PaletteEntries[i]:=PaletteEntries[i+1];
      PaletteEntries[NumPaletteEntries-1]:=PaletteEntry1;
   finally
      EndUpdate;
   end;
   end;
end;

procedure TForm1.animate1Click(Sender: TObject);
begin
Animate1.Checked:=not Animate1.Checked;
PaletteAnimationTimer.Enabled:=Animate1.Checked;
end;

procedure TForm1.Start1Click(Sender: TObject);
begin
Start;
end;

procedure TForm1.ShowProgress1Click(Sender: TObject);
begin
ShowProgress1.Checked:=not ShowProgress1.Checked;
end;

procedure TForm1.Size2Click(Sender: TObject);
var SizeStr: string;
begin
SizeStr:=IntToStr(Size);
if InputQuery('Size', 'Enter max edge length:', SizeStr) then
   begin
   Size:=StrToInt(Trim(SizeStr));
   NewImage(CReMin, CReMax, CImMin, CImMax);
   end;
end;

procedure TForm1.MaxIterations1Click(Sender: TObject);
var ItMaxStr: string;
begin
ItMaxStr:=IntToStr(ItMax);
if InputQuery('ItMax', 'Enter max number of iterations:', ItMaxStr) then
   begin
   ItMax:=StrToInt(Trim(ItMaxStr));
   NewImage(CReMin, CReMax, CImMin, CImMax);
   end;
end;

procedure TForm1.StartTimerTimer(Sender: TObject);
begin
StartTimer.Enabled:=false;
Start;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
var WasAnimated: Boolean;
begin
WasAnimated:=PaletteAnimationTimer.Enabled;
PaletteAnimationTimer.Enabled:=false;
try
   if PGSaveDialog1.Execute then
      PGImage1.SaveToFile(PGSaveDialog1.Filename);
finally
   PaletteAnimationTimer.Enabled:=WasAnimated;
end;
end;

procedure TForm1.Print1Click(Sender: TObject);
var WasAnimated: Boolean;
begin
WasAnimated:=PaletteAnimationTimer.Enabled;
PaletteAnimationTimer.Enabled:=false;
try
   PGImage1.LendNoModifyPixelGraphic.Print(true, true, self);
finally
   PaletteAnimationTimer.Enabled:=WasAnimated;
end;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: Do you have some code that uses palette animation?'#13#13 +
   'Answer: Here is some code... Note that this will work only on 256 or true color systems. Note also that Palette8BitSy8BitGraphic of the PGImage is set to pSource. BTW: This application allows you to select areas with the mouse...'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
