unit FAQ025F;
//
// PixelGraphicLibrary - FAQ 25
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, StdCtrls, ExtCtrls, ComCtrls, Menus;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Panel1: TPanel;
    Panel2: TPanel;
    Button2: TButton;
    Button1: TButton;
    PGImage3: TPGImage;
    PGImage2: TPGImage;
    PGImage1: TPGImage;
    PGOpenDialog1: TPGOpenDialog;
    PGOpenDialog2: TPGOpenDialog;
    Timer1: TTimer;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    Steps1: TMenuItem;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Steps1Click(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
  private
    { Private declarations }
    steps: Integer;
    step: Integer;
    Growing2: Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function ReturnCompatiblePG(aPG: TPixelGraphic): TPixelGraphic;
var
   ScreenDC: HDC;
   DCBitCountNum: Integer;
begin
   ScreenDC:=GetDC(0);
try
   DCBitCountNum := (GetDeviceCaps(ScreenDC,BITSPIXEL) * GetDeviceCaps(ScreenDC, PLANES));
finally
   ReleaseDC(0, ScreenDC);
end; // of try/finally
if (DCBitCountNum<8) and ((aPG.BitCountNum<>4) or (aPG.PaletteKind<>pSys16)) then
   begin
   result:=TPixelGraphic.Create;
   result.SetDimension(aPG.Width, aPG.Height, bc4);
   result.PaletteKind:=pSys16;
   result.StretchDraw(aPG);
   aPG.Free;
   end
else
   if (DCBitCountNum=8) and ((aPG.BitCountNum<>8) or (aPG.PaletteKind<>pSpecial252)) then
      begin
      result:=TPixelGraphic.Create;
      result.SetDimension(aPG.Width, aPG.Height, bc8);
      result.PaletteKind:=pSpecial252;
      result.StretchDraw(aPG);
      aPG.Free;
      end
   else
      if (DCBitCountNum>8) and (aPG.BitCountNum<>24) then
         begin
         result:=TPixelGraphic.Create;
         result.SetDimension(aPG.Width, aPG.Height, bc24);
         result.StretchDraw(aPG);
         aPG.Free;
         end
      else
         result:=aPG;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
   LoadPG: TPixelGraphic;
begin
if PGOpenDialog1.Execute then
   begin
   LoadPG:=TPixelGraphic.create;
   LoadPG.LoadFromFile(PGOpenDialog1.FileName);
   PGImage1.PixelGraphic:=ReturnCompatiblePG(LoadPG);
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   LoadPG: TPixelGraphic;
begin
if PGOpenDialog2.Execute then
   begin
   LoadPG:=TPixelGraphic.create;
   LoadPG.LoadFromFile(PGOpenDialog2.FileName);
   PGImage2.PixelGraphic:=ReturnCompatiblePG(LoadPG);
   end;
end;

function max(a, b: Integer): Integer;
   begin
   result:=a;
   if b>a then
      result:=b;
   end;

procedure TForm1.Timer1Timer(Sender: TObject);
//
// Note: This would be a lot easier if both graphics are of the same size!
//
var
   PG1, PG2, PG3: TPixelGraphic;
   Width1, Height1, Width2, Height2, Width3, Height3: Integer;
   y2, x3, y3: Integer;
   XOffset2, YOffset2: Integer;
   x3MinInner, x3MinOuter, x3MaxInner, x3MaxOuter, y3MinInner, y3MinOuter, y3MaxInner, y3MaxOuter: Integer;

begin
if Growing2 then
   begin
   PG1:=PGImage1.LendNoModifyPixelGraphic;
   PG2:=PGImage2.LendNoModifyPixelGraphic;
   end
else
   begin
   PG1:=PGImage2.LendNoModifyPixelGraphic;
   PG2:=PGImage1.LendNoModifyPixelGraphic;
   end;
PG3:=PGImage3.LendPixelGraphic;
if (PG1<>nil) and (PG2<>nil) then
   begin
   if PG3=nil then
      begin
      PG3:=TPixelGraphic.Create;
      PGImage3.TakePixelGraphic(PG3);
      end;
   PG3.BeginUpdate;
   try
      Width1:=PG1.Width;
      Height1:=PG1.Height;
      Width2:=PG2.Width;
      Height2:=PG2.Height;
      Width3:=max(Width1, Width2);
      Height3:=max(Height1, Height2);
      if (Width3<>PG3.Width) or (Height3<>PG3.Height) then
         begin
         PG3.SetDimension(Width3, Height3, PG1.BitCount);
         if PG3.BitCount<>bc24 then
            PG3.CopyPalette(PG1);     
         end;
      XOffset2:=round((Width2-Width3)/2);
      YOffset2:=round((Height2-Height3)/2);
      x3MinInner:=round(Width3/2*(1-(Step)/Steps));
      x3MinOuter:=round(Width3/2*(1-(Step+1)/Steps));
      x3MaxInner:=round(Width3/2*(1+(Step)/Steps));
      x3MaxOuter:=round(Width3/2*(1+(Step+1)/Steps));
      y3MinInner:=round(Height3/2*(1-(Step)/Steps));
      y3MinOuter:=round(Height3/2*(1-(Step+1)/Steps));
      y3MaxInner:=round(Height3/2*(1+(Step)/Steps));
      y3MaxOuter:=round(Height3/2*(1+(Step+1)/Steps));
      for y3:=y3MinOuter to y3MaxOuter do
         begin
         y2:=y3+YOffSet2;
         if (y3>y3MinInner) and (y3<y3MaxInner) then
            begin
            for x3:=x3MinOuter to x3MinInner do
               PG3.Bits[x3,y3]:=PG2.Bits[x3+XOffSet2, y2];
            for x3:=x3MaxInner to x3MaxOuter do
               PG3.Bits[x3,y3]:=PG2.Bits[x3+XOffSet2, y2];
            end
         else
            for x3:=x3MinOuter to x3MaxOuter do
               PG3.Bits[x3,y3]:=PG2.Bits[x3+XOffSet2, y2];
         end;
   finally
      PG3.EndUpdate;
   end;
   end;
Inc(Step);
if Step>Steps-1 then
   begin
   Step:=0;
   Growing2:=not Growing2;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
Steps:=50;
PGImage1.TakePixelGraphic(ReturnCompatiblePG(PGImage1.GivePixelGraphic));
PGImage2.TakePixelGraphic(ReturnCompatiblePG(PGImage2.GivePixelGraphic));
Info1Click(Self);
end;

procedure TForm1.Steps1Click(Sender: TObject);
var StepsStr: string;
begin
if InputQuery('Steps','Steps:',StepsStr) then
   Steps:=StrToInt(StepsStr);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: Do you have an example how I can generate a transition effect on 16, 256 and true color systems?'#13#13 +
   'Answer: Have a look at this.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;


procedure TForm1.PageControl1Change(Sender: TObject);
begin
PaletteChanged(true);
end;

end.
