unit FAQ024F;
//
// PixelGraphicLibrary - FAQ 24
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, StdCtrls, ExtCtrls, ComCtrls, Menus;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Panel1: TPanel;
    Panel2: TPanel;
    Button2: TButton;
    Button1: TButton;
    PGImage3: TPGImage;
    PGImage2: TPGImage;
    PGImage1: TPGImage;
    PGOpenDialog1: TPGOpenDialog;
    PGOpenDialog2: TPGOpenDialog;
    Timer1: TTimer;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Info1Click(Sender: TObject);
  private
    { Private declarations }
    State510: Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.Button1Click(Sender: TObject);
var
   LoadPG: TPixelGraphic;
   TruePG: TPixelGraphic;
begin
if PGOpenDialog1.Execute then
   begin
   LoadPG:=TPixelGraphic.create;
   LoadPG.LoadFromFile(PGOpenDialog1.FileName);
   if LoadPG.BitCount=bc24 then
      // Loaded graphic is allready true color
      PGImage1.PixelGraphic:=LoadPG
   else
      begin
      // Loaded graphic is not true color so create a true color graphic from it
      TruePG:=TPixelGraphic.Create;
      TruePG.SetDimension(LoadPG.Width, LoadPG.Height, bc24);
      TruePG.StretchDraw(LoadPG);
      PGImage1.PixelGraphic:=TruePG;
      LoadPG.Free;
      end;
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   LoadPG: TPixelGraphic;
   TruePG: TPixelGraphic;
begin
if PGOpenDialog2.Execute then
   begin
   LoadPG:=TPixelGraphic.create;
   LoadPG.LoadFromFile(PGOpenDialog2.FileName);
   if LoadPG.BitCount=bc24 then
      // Loaded graphic is allready true color
      PGImage2.PixelGraphic:=LoadPG
   else
      begin
      // Loaded graphic is not true color so create a true color graphic from it
      TruePG:=TPixelGraphic.Create;
      TruePG.SetDimension(LoadPG.Width, LoadPG.Height, bc24);
      TruePG.StretchDraw(LoadPG);
      PGImage2.PixelGraphic:=TruePG;
      LoadPG.Free;
      end;
   end;
end;

function max(a, b: Integer): Integer;
   begin
   result:=a;
   if b>a then
      result:=b;
   end;

procedure TForm1.Timer1Timer(Sender: TObject);
//
// Note: - This would be a lot easier if both graphics are of the same size!
//       - We don't use the Bits property as it would be to slow!
//
var
   PG1, PG2, PG3: TPixelGraphic;
   Width1, Height1, Width2, Height2, Width3, Height3: Integer;
   x1, y1, x2, y2, x3, y3: Integer;
   YOffset1, YOffset2: Integer;
   State256: Integer;
   Weight1, Weight2: Integer;
   Byte1, Byte2: Byte;
   Pointer1, Pointer2, Pointer3: PByte;
   NumBytes1, NumBytes2, NumBytes3: Integer;
   ByteOffSet1, ByteOffSet2: Integer;
   ByteIndex1, ByteIndex2, ByteIndex3: Integer;
begin
PG1:=PGImage1.LendNoModifyPixelGraphic;
PG2:=PGImage2.LendNoModifyPixelGraphic;
PG3:=PGImage3.LendPixelGraphic;
if (PG1<>nil) and (PG2<>nil) then
   begin
   if PG3=nil then
      begin
      PG3:=TPixelGraphic.Create;
      PGImage3.TakePixelGraphic(PG3);
      end;
   PG3.BeginUpdate;
   Width1:=PG1.Width;
   NumBytes1:=3*Width1;
   Height1:=PG1.Height;
   Width2:=PG2.Width;
   NumBytes2:=3*Width2;
   Height2:=PG2.Height;
   Width3:=max(Width1, Width2);
   NumBytes3:=3*Width3;
   Height3:=max(Height1, Height2);
   if (Width3<>PG3.Width) or (Height3<>PG3.Height) then
      PG3.SetDimension(Width3, Height3, bc24);
   ByteOffset1:=3*((Width1-Width3) div 2);
   YOffset1:=(Height1-Height3) div 2;
   ByteOffset2:=3*((Width2-Width3) div 2);
   YOffset2:=(Height2-Height3) div 2;
   if State510<=255 then
      State256:=State510
   else
      State256:=510-State510;
   Weight1:=State256;
   Weight2:=255-State256;
   for y3:=0 to Height3-1 do
      begin
      y1:=y3+YOffSet1;
      if (y1>=0) and (y1<Height1) then
         Pointer1:=PG1.ScanlineBytes[y1]
      else
         Pointer1:=nil;
      y2:=y3+YOffSet2;
      if (y2>=0) and (y2<Height2) then
         Pointer2:=PG2.ScanlineBytes[y2]
      else
         Pointer2:=nil;
      Pointer3:=PG3.ScanlineBytes[y3];
      ByteIndex1:=ByteOffSet1;
      ByteIndex2:=ByteOffSet2;
      for ByteIndex3:=0 to NumBytes3-1 do
         begin
         if (Pointer1<>nil) and (ByteIndex1>=0) and (ByteIndex1<NumBytes1) then
            begin
            Byte1:=Pointer1^;
            Inc(Pointer1);
            end
         else
            Byte1:=$C0; // Background gray value
         Inc(ByteIndex1);
         if (Pointer2<>nil) and (ByteIndex2>=0) and (ByteIndex2<NumBytes2) then
            begin
            Byte2:=Pointer2^;
            Inc(Pointer2);
            end
         else
            Byte2:=$C0; // Background gray value
         Inc(ByteIndex2);
         Pointer3^:=(Weight1*Byte1+Weight2*Byte2) div 255;
         Inc(Pointer3);
         end;
      end;
   PG3.EndUpdate;
   end;
State510:=State510+8;
if State510>509 then
   State510:=0;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   ScreenDC: HDC;
   DCBitCount: Integer;
begin
Info1Click(Self);
ScreenDC:=GetDC(0);
try
   DCBitCount := (GetDeviceCaps(ScreenDC,BITSPIXEL) * GetDeviceCaps(ScreenDC, PLANES));
finally
   ReleaseDC(0, ScreenDC);
end; // of try/finally
if DCBitCount<=8 then
   begin
   ShowMessage('This application requires a true color system...');
   Application.Terminate;
   end;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(       
   'Question: How can I generate a transition effect?'#13#13 +
   'Answer: Here is an example, but it will only work for small images on true color systems.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
