unit FAQ023F;
//
// PixelGraphicLibrary - FAQ 23
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
{Thanks Ruud!}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, PGraphic;

type
  TForm1 = class(TForm)
    PGImage1: TPGImage;
    ColorDialog1: TColorDialog;
    ColorDialog2: TColorDialog;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    Panel1: TPanel;
    Button1: TButton;
    Panel2: TPanel;
    Button2: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    procedure DataChanged(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Info1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DataChanged(Sender: TObject);
var
   LeftRGB, RightRGB, aRGB: TRGB;
   LeftR, LeftG, LeftB, RightR, RightG, RightB: Byte;
   x, y, aWidth, aHeight: Integer;
   aPG: TPixelGraphic;
begin
LeftRGB:=ColorToRGB(ColorDialog1.Color);
LeftR:=GetRValue(LeftRGB);
LeftG:=GetGValue(LeftRGB);
LeftB:=GetBValue(LeftRGB);
RightRGB:=ColorToRGB(ColorDialog2.Color);
RightR:=GetRValue(RightRGB);
RightG:=GetGValue(RightRGB);
RightB:=GetBValue(RightRGB);
try
   aWidth:=StrToInt(Edit1.Text);
   aHeight:=StrToInt(Edit2.Text);
except
   aWidth:=1;
   aHeight:=1;
end;
aPG:=TPixelGraphic.Create;
try
   aPG.SetDimension(aWidth, aHeight, bc24);
   for x:=0 to aWidth-1 do
      begin
      aRGB:=rgb(
          (x*(RightR-LeftR)) div aWidth + LeftR,
          (x*(RightG-LeftG)) div aWidth + LeftG,
          (x*(RightB-LeftB)) div aWidth + LeftB);
      for y:=0 to aHeight-1 do
         aPG.Bits[x,y]:=aRGB;
      end;
   PGImage1.PixelGraphic:=aPG;
except
   aPG.Free;
   raise;
end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
if ColorDialog1.Execute then
   DataChanged(Self);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if ColorDialog2.Execute then
   DataChanged(Self);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
DataChanged(Self);
Info1.Click;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I draw a gradient fill to a PixelGraphic?'#13#13 +
   'Answer: Here is an example...'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
