unit FAQ019F;
//
// PixelGraphicLibrary - FAQ 19
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PGImage1: TPGImage;
    Timer1: TTimer;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    Step: Integer;
    Delta: Integer;
    PalRValues: array[0..255] of Byte;
    PalGValues: array[0..255] of Byte;
    PalBValues: array[0..255] of Byte;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
var
   LoadPG: TPixelGraphic;
   PalPG: TPixelGraphic;
   i: Integer;
begin
// Load from file, create a dithered PixelGraphic and memorize the "original" palette
Timer1.Enabled:=false;
IF PGOpenDialog1.Execute then
   begin
   LoadPG:=TPixelGraphic.Create;
   LoadPG.LoadFromFile(PGOpenDialog1.Filename);
   PalPG:=TPixelGraphic.Create;
   PalPG.SetDimension(LoadPG.Width, LoadPG.Height, bc8);
   PalPG.CreateOptimizedPalette(LoadPG, 236, false);
   for i:=0 to PalPG.NumPaletteEntries-1 do
      begin
      PalRValues[i]:=GetRValue(PalPG.PaletteEntries[i]);
      PalGValues[i]:=GetGValue(PalPG.PaletteEntries[i]);
      PalBValues[i]:=GetBValue(PalPG.PaletteEntries[i]);
      end;
   // You might want to set some dither otions here
   PalPG.StretchDraw(LoadPG);
   PalPG.PaletteAnimation:=true; // important on 256 color systems
   PGImage1.TakePixelGraphic(PalPG);
   LoadPG.Free;
   Step:=255;
   Delta:=-4;
   Timer1.Enabled:=true;
   end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
   PalPG: TPixelGraphic;
   i: Integer;
begin
PalPG:=PGImage1.PixelGraphic;
PalPG.BeginUpdate;
for i:=0 to PalPG.NumPaletteEntries-1 do
   PalPG.PaletteEntries[i]:=rgb(PalRValues[i]*Step div 255, PalGValues[i]*Step div 255, PalBValues[i]*Step div 255);
PalPG.EndUpdate;
Step:=Step+Delta;
if Step<0 then
   begin
   Step:=0;
   Delta:=4;
   end;
if Step>255 then
   begin
   Step:=255;
   Delta:=-4;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   ScreenDC: HDC;
   DCBitCount: Integer;
begin
Info(Self);
ScreenDC:=GetDC(0);
try
   DCBitCount := (GetDeviceCaps(ScreenDC,BITSPIXEL) * GetDeviceCaps(ScreenDC, PLANES));
finally
   ReleaseDC(0, ScreenDC);
end; // of try/finally
if DCBitCount<8 then
   begin
   ShowMessage('This application requires a 256 or true color system...');
   Application.Terminate;
   end;
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I slowly fade a PixelGraphic, which is displayed in a TPGImage, to black?'#13#13 +
   'Answer: Create a PixelGraphic that has a palette with max. 236 entries. Set TPixelGraphic.PaletteAnimation to true. Set TPGImage.Palette8BitSys8BitGraphic to pSource. Use a timer to update the TPixelGraphic.PaletteEntries.'+#13#13+
   'Note: This will not work on 16 color systems!'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
