unit FAQ013F;
//
// PixelGraphicLibrary - FAQ 13
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    SaveResult1: TMenuItem;
    PGImageResult: TPGImage;
    PGImageSource: TPGImage;
    PGSaveDialog1: TPGSaveDialog;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure SaveResult1Click(Sender: TObject);
    procedure PGImageSourcePixelGraphicChange(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImageSource.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.SaveResult1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImageResult.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.PGImageSourcePixelGraphicChange(Sender: TObject);
var
   SourcePG: TPixelGraphic;
   ResultPG: TPixelGraphic;
   aFilter: TCMYFilter;
   i: Integer;
begin
SourcePG:=PGImageSource.LendNoModifyPixelGraphic;
ResultPG:=TPixelGraphic.Create;
ResultPG.SetDimension(SourcePG.Width, SourcePG.Height, bc24);
aFilter:=TCMYFilter.Create;
for i:=0 to 255 do
   begin
   aFilter.CyanValues[i]:=i;
   aFilter.MagentaValues[i]:=i div 2;
   aFilter.YellowValues[i]:=i;
   end;
ResultPG.ApplyFilter(aFilter, SourcePG);
PGImageResult.TakePixelGraphic(ResultPG);
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
PaletteChanged(true);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: Can I use TCMYFilter without using TCMYFilterDialog?'#13#13+
   'Answer: Yes, here is an example. This example will just half the intensity of Magenta.'#13#13+
   'Note: You can set non linear profiles to CyanValues, MagentaValues and YellowValues.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

end.
