unit FAQ011F;
//
// PixelGraphicLibrary - FAQ 11
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    SaveResult1: TMenuItem;
    PGImageResult: TPGImage;
    PGImageSource: TPGImage;
    PGSaveDialog1: TPGSaveDialog;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure SaveResult1Click(Sender: TObject);
    procedure PGImageSourcePixelGraphicChange(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImageSource.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.SaveResult1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImageResult.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.PGImageSourcePixelGraphicChange(Sender: TObject);
var
   SourcePG: TPixelGraphic;
   ResultPG: TPixelGraphic;
   x, y: Integer;
   aHeight, aWidth: Integer;
   aSourcePointer: PByte;
   aResultPointer: PByte;
begin
SourcePG:=PGImageSource.LendNoModifyPixelGraphic;
if SourcePG.BitCount=bc24 then
   begin
   ResultPG:=TPixelGraphic.Create;
   ResultPG.SetDimension(SourcePG.Width, SourcePG.Height, bc8);
   ResultPG.PaletteKind:=pGray256;
   aHeight:=SourcePG.Height;
   aWidth:=SourcePG.Width;
   for y:=0 to aHeight-1 do
      begin
      aResultPointer:=ResultPG.ScanLineBytes[y];
      aSourcePointer:=SourcePG.ScanLineBytes[y];
      for x:=0 to aWidth-1 do
         begin
         aResultPointer^:=aSourcePointer^;
         inc(aResultPointer);
         aSourcePointer:=PByte(Integer(aSourcePointer)+3);
         end;
      end;
   PGImageResult.TakePixelGraphic(ResultPG);
   end
else
   begin
   PGImageResult.TakePixelGraphic(nil);
   raise Exception.Create('Not true color');
   end;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
PaletteChanged(true);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I create a grayscaled PixelGraphic from a true color '+
   'PixelGraphic that contains already a grayscaled image (R=G=B). FAQ009 and '+
   'FAQ010 work fine but my source is true color and red is equal to green and '+
   'to blue for each pixel. I need a very fast solution. Can'#39't I access '+
   'the bits of the of the bitmaps directly without using the Bits property?'#13#13 +
   'Answer: Create a second PixelGraphic with same width and height and BitCount=bc8. '+
   'Set PaletteKind to pGray256. Use the ScanLineBytes to get Pointers to the Scanlines.'+#13#13+
   'Note: This very fast way is only for experienced programmers who know how '+
   'Windows bitmaps are organized internally.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
