unit FAQ010F;
//
// PixelGraphicLibrary - FAQ 10
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    SaveResult1: TMenuItem;
    PGImageResult: TPGImage;
    PGImageSource: TPGImage;
    PGSaveDialog1: TPGSaveDialog;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure SaveResult1Click(Sender: TObject);
    procedure PGImageSourcePixelGraphicChange(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImageSource.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.SaveResult1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImageResult.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.PGImageSourcePixelGraphicChange(Sender: TObject);
var
   SourcePG: TPixelGraphic;
   ResultPG: TPixelGraphic;
   x, y: Integer;
   aWidth: Integer;
   aHeight: Integer;
   aRGB: TRGB;
begin
SourcePG:=PGImageSource.LendNoModifyPixelGraphic;
if SourcePG.BitCount=bc24 then
   begin
   ResultPG:=TPixelGraphic.Create;
   ResultPG.SetDimension(SourcePG.Width, SourcePG.Height, bc8);
   ResultPG.PaletteKind:=pGray256;
   aHeight:=SourcePG.Height;
   aWidth:=SourcePG.Width;
   for y:=0 to aHeight-1 do
      for x:=0 to aWidth-1 do
         begin
         aRGB:=SourcePG.Bits[x,y];
         ResultPG.Bits[x,y]:=(GetRValue(aRGB)+GetGValue(aRGB)+GetBValue(aRGB)) div 3;
         end;
   PGImageResult.TakePixelGraphic(ResultPG);
   end
else
   begin
   PGImageResult.TakePixelGraphic(nil);
   raise Exception.Create('Not true color');
   end;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
PaletteChanged(true);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I create a grayscaled PixelGraphic from a true color PixelGraphic. FAQ009 works fine but my source is true color and I think it might be faster to use the Bits properties.'#13#13 +
   'Answer: Create a second PixelGraphic with same width and height and BitCount=bc8. '+
   'Set PaletteKind to pGray256. Read the Bits from the true color source PixelGraphic and set the Bits in the grayscale result PixelGraphic.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
