unit FAQ008F;
//
// PixelGraphicLibrary - FAQ 8
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    SaveResult1: TMenuItem;
    PGImageResult: TPGImage;
    PGImageSource: TPGImage;
    PGSaveDialog1: TPGSaveDialog;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure SaveResult1Click(Sender: TObject);
    procedure PGImageSourcePixelGraphicChange(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImageSource.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.SaveResult1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImageResult.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.PGImageSourcePixelGraphicChange(Sender: TObject);
var
   SourcePG: TPixelGraphic;
   ResultPG: TPixelGraphic;
   i: Integer;

begin
SourcePG:=PGImageSource.LendNoModifyPixelGraphic;
ResultPG:=TPixelGraphic.Create;
ResultPG.SetDimension(SourcePG.Width, SourcePG.Height, bc8);
// This examples generates a palette that includes black, white and 254 random entries. You will create "your" palette here.
ResultPG.NumPaletteEntries:=256;
ResultPG.PaletteEntries[0]:=rgb(0, 0, 0);
ResultPG.PaletteEntries[1]:=rgb(255, 255, 255);
Randomize;
for i:= 2 to 255 do
   ResultPG.PaletteEntries[i]:=rgb(Random(256), Random(256), Random(256));
// You might want to set some dither options here
ResultPG.StretchDraw(SourcePG);
PGImageResult.TakePixelGraphic(ResultPG);
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
PaletteChanged(true);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: I want to map a PixelGraphic to a palette that has "my" palette entries. How can I do this?'#13#13 +
   'Answer: Create a second PixelGraphic with same width and height and BitCount=bc1...bc8 (depending on the numbers of palette entries). '+
   'Set NumPaletteEntries, set PaletteEntries[0...NumPaletteEntries-1] and StretchDraw the first on the second PixelGraphic.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
