unit FAQ002F;
//
// PixelGraphicLibrary - FAQ 2
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    PixelGraphicLibraryFAQ0031: TMenuItem;
    PGImage1: TPGImage;
    Panel1: TPanel;
    Button1: TButton;
    procedure Info(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
   aPG: TPixelGraphic;
   x, y: Integer;
begin
aPG:=TPixelGraphic.Create;
aPG.SetDimension(256, 256, bc8);
aPG.PaletteKind:=pGray256;
// Note the Bits property is faster than the Pixels property! Bits[x,y]:=37 is faster than Pixels[x,y]:=rgb(37,37,37)
for y:=0 to 255 do
   for x:=0 to 255 do
      aPG.Bits[x,y]:=y;
PGImage1.PixelGraphic:=aPG; // same like PGImage1.TakePixelGraphic(aPG);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I create a 8 bit grayscale PixelGraphic?'#13#13 +
   'Answer: Create a PixelGraphic, call SetDimension with bc8 for BitCount and set PaletteKind to pGray256.'+#13#13+
   'Note: If you want to perform other operations like StretchDrawRect... '+
   'you should set TPixelGraphic.Dither to false if the PixelGraphic has a '+
   'pGray256 palette because dithering will not improve the quality for images '+
   'with PaletteKind pGray256 and dithering slows down several operations.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13+
   'http://www.beyersdorf.com/');
end;

end.
