unit Demo19F1;
//
// PixelGraphicLibrary - Demo 19
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

{Thanks to Bill Miller for suggesting to include a demo/FAQ about this subject.}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, Buttons, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Saveas1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PGSaveDialog1: TPGSaveDialog;
    Info1: TMenuItem;
    PGImage1: TPGImage;
    Print1: TMenuItem;
    Changecolorresolution1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Changecolorresolution1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Demo19F2;

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
PGOpenDialog1.Filename:=PGImage1.Filename;
if PGOpenDialog1.Execute then
   PGImage1.Filename:=PGOpenDialog1.Filename;
Saveas1.Enabled:=not PGImage1.Empty;
Print1.Enabled:=not PGImage1.Empty;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
PGSaveDialog1.Filename:=PGImage1.Filename;
if PGSaveDialog1.Execute then
   PGImage1.SaveToFile(PGSaveDialog1.Filename);
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
PGImage1.LendPixelGraphic.Print(true, true, self);
end;

procedure TForm1.Info1Click(Sender: TObject);
// Set application title and show the info-message
begin
Application.Title:=Caption;
ShowMessage(
   'This should demonstrate how you can change graphics'#39' color resolution.' + #13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/'+#13#13+
   'The PixelGraphicLibrary Mailing List is a place to discuss technical issues. '+
   'Send an e-mail with the word intro in the message'#39's body to '+
   'pixelgraphiclibrary-request@mailinglist.net to get more information.');
end;
procedure TForm1.Changecolorresolution1Click(Sender: TObject);
var
   SrcPG: TPixelGraphic;
   DestPG: TPixelGraphic;
   aBitCount: TBitCount;
begin
if (not PGImage1.Empty) and (Form2.ShowModal=mrOK) then
   begin
   Update;
   DestPG:=TPixelGraphic.Create;
   try
      SrcPG:=PGImage1.LendNoModifyPixelGraphic;
      with Form2 do
         begin
         aBitCount:=bc24;
         if BC1RB.Checked then
            aBitCount:=bc1;
         if BC4RB.Checked then
            aBitCount:=bc4;
         if BC8RB.Checked then
            aBitCount:=bc8;
         DestPG.SetDimension(SrcPG.Width, SrcPG.Height, aBitCount);
         if BC1RB.Checked then
            begin
            if BC1BlackWhiteRB.Checked then
               DestPG.PaletteKind:=pBlackWhite;
            if BC1OptimizedRB.Checked then
               DestPG.CreateOptimizedPalette(SrcPG,2,false);
            end;
         if BC4RB.Checked then
            begin
            if BC4Gray4RB.Checked then
               DestPG.PaletteKind:=pGray4;
            if BC4GraySys4RB.Checked then
               DestPG.PaletteKind:=pSysGray4;
            if BC4Gray16RB.Checked then
               DestPG.PaletteKind:=pGray16; // here was a bug in versions < 1.0 beta 5
            if BC4Sys16RB.Checked then
               DestPG.PaletteKind:=pSys16;
            if BC4OptimizedRB.Checked then
               DestPG.CreateOptimizedPalette(SrcPG,StrToInt(Trim(BC4ColorsEdit.text)),false);
            end;
         if BC8RB.Checked then
            begin
            if BC8Gray236RB.Checked then
               DestPG.PaletteKind:=pGray236;
            if BC8Gray256RB.Checked then
               DestPG.PaletteKind:=pGray256;
            if BC8Special125RB.Checked then
               DestPG.PaletteKind:=pSpecial125;
            if BC8Special216RB.Checked then
               DestPG.PaletteKind:=pSpecial216;
            if BC8Special252RB.Checked then
               DestPG.PaletteKind:=pSpecial252;
            if BC8OptimizedRB.Checked then
               DestPG.CreateOptimizedPalette(SrcPG,StrToInt(Trim(BC8ColorsEdit.text)),BC8OptimizedIncludeSys16CB.Checked);
            end;
         DestPG.Dither:=DitheringCB.Checked;
         DestPG.RGBWeighting:=RGBWeightingCB.Checked;
         DestPG.StretchDraw(SrcPG);
         PGImage1.TakePixelGraphic(DestPG);
         end;
   except
      DestPG.Free;
   end;
   end;
end;

end.
