unit Demo18F1;
//
// PixelGraphicLibrary - Demo 18
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, PGraphic, ExtCtrls, Menus;
 
type
  TForm1 = class(TForm)
    ToolPanel: TPanel;
    PGImage: TPGImage;
    PGOpenDialog: TPGOpenDialog;
    PGSaveDialog: TPGSaveDialog;
    LineSB: TSpeedButton;
    RectSB: TSpeedButton;
    EllipseSB: TSpeedButton;
    LinesSB: TSpeedButton;
    RectFilledSB: TSpeedButton;
    EllipseFilledSB: TSpeedButton;
    PenColorSB: TSpeedButton;
    BrushColorSB: TSpeedButton;
    PenWidthComboBox: TComboBox;
    TextSB: TSpeedButton;
    PenColorDialog: TColorDialog;
    BrushColorDialog: TColorDialog;
    MainMenu: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    Edit1: TMenuItem;
    Undo1: TMenuItem;
    FontDialog: TFontDialog;
    MoveSpeedButton: TSpeedButton;
    FillSB: TSpeedButton;
    IgnoreBrushTimer: TTimer;
    Info1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure PenColorSBClick(Sender: TObject);
    procedure BrushColorSBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MoveSpeedButtonClick(Sender: TObject);
    procedure DrawSpeedButtonClicked(Sender: TObject);
    procedure TextSBClick(Sender: TObject);
    procedure PGImagePicBoxOnMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PGImagePicBoxOnMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure PGImagePicBoxOnMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PGImagePicBoxOnPaint(Sender: TObject);
    procedure IgnoreBrushTimerTimer(Sender: TObject);
    procedure PGImagePicBoxOnSetCursor(Sender: TObject;
      var CursorHandle: Integer);
    procedure New1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
  private
    { Private declarations }
    Text: string;
    HaveCapture: Boolean;
    FromX: Integer;
    FromY: Integer;
    ToX: Integer;
    ToY: Integer;
    IgnoreBrush: Boolean;
    LineCursorHandle: HCursor;
    LinesCursorHandle: HCursor;
    FillCursorHandle: HCursor;
    TextCursorHandle: HCursor;
    RectCursorHandle: HCursor;
    RectFilledCursorHandle: HCursor;
    EllipseCursorHandle: HCursor;
    EllipseFilledCursorHandle: HCursor;
    LinesList: TList;
    UndoFileName: string;
    FileName: string;
    procedure Draw(OnPixelGraphic: Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Demo18F2;

{$R *.DFM}
{$R *.res}

procedure TForm1.PenColorSBClick(Sender: TObject);
begin
PenColorDialog.Execute;
end;

procedure TForm1.BrushColorSBClick(Sender: TObject);
begin
BrushColorDialog.Execute;
end;

const
   aPrefix = 'PGP' + #0;

function CreateTempFileName: string;
   var
      aPathBuffer: array [0 .. 1023] of Char;
      aFilenameBuffer: array [0 .. 1023] of Char;

   begin
   GetTempPath(1024, aPathBuffer);
   GetTempFileName(aPathBuffer, aPrefix, 0, aFilenameBuffer);
   result := StrPas(aFilenameBuffer);
   end;

procedure TForm1.FormCreate(Sender: TObject);
begin
LineCursorHandle:=LoadCursor(HInstance, 'LINECURSOR');
LinesCursorHandle:=LoadCursor(HInstance, 'LINESCURSOR');
FillCursorHandle:=LoadCursor(HInstance, 'FILLCURSOR');
TextCursorHandle:=LoadCursor(HInstance, 'TEXTCURSOR');
RectCursorHandle:=LoadCursor(HInstance, 'RECTCURSOR');
RectFilledCursorHandle:=LoadCursor(HInstance, 'RECTFILLEDCURSOR');
EllipseCursorHandle:=LoadCursor(HInstance, 'ELLIPSEFILLEDCURSOR');
EllipseFilledCursorHandle:=LoadCursor(HInstance, 'ELLIPSEFILLEDCURSOR');
PenWidthComboBox.ItemIndex:=0;
Text:='Text';
HaveCapture:=false;
LinesList:=TList.Create;
Info1.Click;
PGImage.PixelGraphic:=TPixelGraphic.Create;
UndoFilename:=CreateTempFileName;
FileName:='';
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
LinesList.Free;
DeleteFile(UndoFileName);
end;

procedure TForm1.MoveSpeedButtonClick(Sender: TObject);
begin
PGImage.ActionMode:=amMoveImage;
end;

procedure TForm1.DrawSpeedButtonClicked(Sender: TObject);
begin
PGImage.ActionMode:=amNone;
end;

procedure TForm1.TextSBClick(Sender: TObject);
begin
DrawSpeedButtonClicked(Sender);
if FontDialog.Execute then
   InputQuery('Text ', 'Enter Text to draw', Text);
end;

procedure TForm1.Draw(OnPixelGraphic: Boolean);
var
   aCanvas: TCanvas;
   i: Integer;
begin
if OnPixelGraphic then
   aCanvas:=PGImage.PixelGraphic.Canvas
else
   aCanvas:=PGImage.PicBox.Canvas;
with aCanvas do
   begin
   Brush.Color:=BrushColorDialog.Color;
   // avoid to much flickering
   if IgnoreBrush and not OnPixelGraphic then
      Brush.Style:=bsClear
   else
      Brush.Style:=bsSolid;
   Pen.Color:=PenColorDialog.Color;
   Pen.Width:=StrToInt(PenWidthComboBox.Text);
   Font:=FontDialog.Font;
   if LineSB.Down then
      begin
      MoveTo(FromX, FromY);
      LineTo(ToX, ToY);
      end;
   if LinesSB.Down then
      begin
      if LinesList.Count>0 then
         begin
         MoveTo(PPoint(LinesList.Items[0]).X, PPoint(LinesList.Items[0]).Y);
         for i:=0 to LinesList.Count-1 do
            LineTo(PPoint(LinesList.Items[i]).X, PPoint(LinesList.Items[i]).Y);
         end;
      end;
   if RectSB.Down then
      begin
      Brush.Style:=bsClear;
      Rectangle(FromX, FromY, ToX, ToY);
      end;
   if RectFilledSB.Down then
      Rectangle(FromX, FromY, ToX, ToY);
   if EllipseSB.Down then
      begin
      Brush.Style:=bsClear;
      Ellipse(FromX, FromY, ToX, ToY);
      end;
   if EllipseFilledSB.Down then
      Ellipse(FromX, FromY, ToX, ToY);
   if TextSB.Down then
      begin
      Brush.Style:=bsClear;
      TextOut(ToX, ToY, Text);
      end;
   end;
// IMPORTANT:
// Call FreePGMemoryContexts at the end of procedures when you used
// TPixelGraphic.Canvas before Application.ProcessMessages can be called!
FreePGMemoryContexts;
end;

function NewPoint(X, Y: Integer): PPoint;
   begin
   result:=new(PPoint);
   result.X:=X;
   result.Y:=Y;
   end;

procedure TForm1.PGImagePicBoxOnMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
if LineSB.Down or LinesSB.Down or RectSB.Down or RectFilledSB.Down or EllipseSB.Down or EllipseFilledSB.Down or TextSB.Down then
   begin
   FromX:=X;
   FromY:=Y;
   ToX:=X;
   ToY:=Y;
   SetCapture(PGImage.Handle);
   HaveCapture:=true;
   if LinesSB.Down then
      LinesList.Add(NewPoint(X, Y));
   PGImage.Invalidate;
   end;
if FillSB.Down then
   begin
   with PGImage.PixelGraphic do
      begin
      WriteToTempFile(UndoFileName);
      Canvas.Brush.Color:=BrushColorDialog.Color;
      Canvas.Brush.Style:=bsSolid;
      Canvas.FloodFill(X, Y, PGImage.PixelGraphic.Canvas.Pixels[x, y], fsSurface);
      end;
   end;
// IMPORTANT:
// Call FreePGMemoryContexts at the end of procedures when you used
// TPixelGraphic.Canvas before Application.ProcessMessages can be called!
FreePGMemoryContexts;
end;

procedure TForm1.PGImagePicBoxOnMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
if HaveCapture then
   begin
   ToX:=X;
   ToY:=Y;
   // avoid to much flickering
   IgnoreBrush:=true;
   IgnoreBrushTimer.Enabled:=true;
   if LinesSB.Down then
      LinesList.Add(NewPoint(X, Y));
   PGImage.Invalidate;
   end;
end;

procedure TForm1.PGImagePicBoxOnMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
   i: Integer;
begin
if HaveCapture then
   begin
   ReleaseCapture;
   HaveCapture:=false;
   ToX:=X;
   ToY:=Y;
   if LinesSB.Down then
      LinesList.Add(NewPoint(X, Y));
   PGImage.PixelGraphic.WriteToTempFile(UndoFileName);
   Draw(true);
   if LinesList.Count>0 then
      for i:=0 to LinesList.Count-1 do
         Dispose(LinesList.Items[i]);
   LinesList.Clear;
   end;
end;

procedure TForm1.PGImagePicBoxOnPaint(Sender: TObject);
begin
if HaveCapture then
   Draw(false);
end;

procedure TForm1.IgnoreBrushTimerTimer(Sender: TObject);
begin
IgnoreBrush:=false;
IgnoreBrushTimer.Enabled:=false;
PGImage.Invalidate;
end;

procedure TForm1.PGImagePicBoxOnSetCursor(Sender: TObject;
  var CursorHandle: Integer);
begin
if LineSB.Down then
   CursorHandle:=LineCursorHandle
else
   if LinesSB.Down then
      CursorHandle:=LinesCursorHandle
   else
      if FillSB.Down then
         CursorHandle:=FillCursorHandle
      else
         if TextSB.Down then
            CursorHandle:=TextCursorHandle
         else
            if RectSB.Down then
               CursorHandle:=RectCursorHandle
            else
               if RectFilledSB.Down then
                  CursorHandle:=RectFilledCursorHandle
               else
                  if EllipseSB.Down then
                     CursorHandle:=EllipseCursorHandle
                  else
                     if EllipseFilledSB.Down then
                        CursorHandle:=EllipseFilledCursorHandle;
end;

procedure TForm1.New1Click(Sender: TObject);
var
   aPaletteKind: TPaletteKind;
   aBitCount: TBitCount;
   aWidth: Integer;
   aHeight: Integer;
begin
if Form2.ShowModal=mrOK then
   begin
   aWidth:=StrToInt(Form2.Edit1.Text);
   aHeight:=StrToInt(Form2.Edit2.Text);
   case Form2.RadioGroup1.ItemIndex of
      0: aBitCount:=bc1;
      1: aBitCount:=bc4;
      2: aBitCount:=bc8;
   else
      aBitCount:=bc24;
   end;
   PGImage.KeepOldPaintPixelGraphic:=false;
   PGImage.PixelGraphic.SetDimension(aWidth, aHeight, aBitCount);
   if aBitCount<>bc24 then
      begin
      aPaletteKind:=pNone;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pBlackWhite' then
         aPaletteKind:=pBlackWhite;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSysGray4' then
         aPaletteKind:=pSysGray4;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSys16' then
         aPaletteKind:=pSys16;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pGray4' then
         aPaletteKind:=pGray4;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pGray16' then
         aPaletteKind:=pGray16;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pGray236' then
         aPaletteKind:=pGray236;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pGray256' then
         aPaletteKind:=pGray256;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSpecial125' then
         aPaletteKind:=pSpecial125;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSpecial216' then
         aPaletteKind:=pSpecial216;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSpecial252' then
         aPaletteKind:=pSpecial252;
      PGImage.PixelGraphic.PaletteKind:=aPaletteKind;
      end;
   PGImage.KeepOldPaintPixelGraphic:=true;
   DeleteFile(UndoFileName);
   FileName:='';
   end;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
PGOpenDialog.FileName:=FileName;
if PGOpenDialog.Execute then
   begin
   FileName:=PGOpenDialog.FileName;
   PGImage.FileName:=PGOpenDialog.FileName;
   DeleteFile(UndoFileName);
   end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
if PGImage.FileName<>'' then
   PGImage.SaveToFile(PGImage.FileName);
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
PGSaveDialog.FileName:=FileName;
if PGSaveDialog.Execute then
   begin
   FileName:=PGSaveDialog.FileName;
   PGImage.SaveToFile(PGSaveDialog.FileName); // here was a bug in versions < 1.0 beta 5
   end;
end;

procedure TForm1.Undo1Click(Sender: TObject);
begin
if FileExists(UndoFileName) then
   PGImage.PixelGraphic.ReadFromTempFile(UndoFileName);
end;

procedure TForm1.Info1Click(Sender: TObject);
// Set application title and show the info-message
begin
Application.Title:=Caption;
ShowMessage(
   'This should demonstrate how can use the PixelGraphicLibrary to create a drawing application.'+ #13#13 +
   'Note that you should call FreePGMemoryContexts at the end of a procedure that used a PixelGraphic'#39's Canvas.' + #13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
