unit Demo12F;
//
// PixelGraphicLibrary - Demo 12
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface
uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
         Menus, PGraphic;

type
   TForm1 = class (TForm)
      PGImage1: TPGImage;
      MainMenu1: TMainMenu;
      File1: TMenuItem;
      Info1: TMenuItem;
      Open1: TMenuItem;
      PGOpenDialog1: TPGOpenDialog;
      procedure Open1Click(Sender: TObject);
      procedure Info1Click(Sender: TObject);
      procedure PGImage1NewAutoSize(Sender: TObject; PGImageWidth,
            PGImageHeight: Integer);
      procedure FormCreate(Sender: TObject);
   private
      { Private-Deklarationen }
   public
      { Public-Deklarationen }
   end;

var
   Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
if PGOpenDialog1.Execute then
   PGImage1.Filename := PGOpenDialog1.Filename;
end;

procedure TForm1.PGImage1NewAutoSize(Sender: TObject; PGImageWidth,
      PGImageHeight: Integer);
begin
// fit the form to the image
if WindowState = wsNormal then
   begin
   ClientHeight := PGImageHeight;
   ClientWidth := PGImageWidth;
   if Left + Width > Screen.Width then
      Left := Screen.Width - Width;
   if Top + Height > Screen.Height then
      Top := Screen.Height - Height;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
// calculate possible max. size
PGImage1.AutoSizeMaxWidth := Screen.Width - (Width - ClientWidth);
PGImage1.AutoSizeMaxHeight := Screen.Height - (Height - ClientHeight);
Info1Click(Self);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This demonstrates the use of the properties AutoSizeMaxHeight and ' +
   'AutoSizeMaxWidth and the event OnNewAutoSize.'+ #13#13 +
   'Please load pictures of different sizes, even larger than your ' +
   'screen.'#13#13 +
   'Note that AutoSize=False and Align=alClient! Setting a new size of ' +
   'the form is done when OnNewAutoSize is called.'#13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.

