unit Demo10F;
//
// PixelGraphicLibrary - Demo 10
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, PGraphic;

type
  TForm1 = class(TForm)
    PGImage1: TPGImage;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    SetPixels1: TMenuItem;
    UseTPixelGraphicPixels1: TMenuItem;
    UseTCanvasPixels1: TMenuItem;
    procedure Info1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure UseTPixelGraphicPixels1Click(Sender: TObject);
    procedure UseTCanvasPixels1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
PGImage1.TakePixelGraphic(TPixelGraphic.Create);
PGImage1.PixelGraphic.SetDimension(256, 256, bc24);
Info1Click(Self);
end;

procedure TForm1.UseTPixelGraphicPixels1Click(Sender: TObject);
var
   x, y: Integer;
   tc: Integer;
   ThePixelGraphic: TPixelGraphic;
begin
ThePixelGraphic:=PGImage1.PixelGraphic;
tc:=GetTickCount; // memorize "time"
for x := 0 to 255 do
   for y := 0 to 255 do
      ThePixelGraphic.Pixels[x,y]:=rgb(x,0,y);
tc:=GetTickCount-tc; // calculate time needed
PGImage1.PixelGraphic.Changed(Self);
ShowMessage('Needed '+FloatToStr(tc/1000)+' seconds to set the color of 65636 pixels using TPixelGraphic.Pixels.');
end;

procedure TForm1.UseTCanvasPixels1Click(Sender: TObject);
var
   x, y: Integer;
   tc: Integer;
   TheCanvas: TCanvas;
begin
PGImage1.PixelGraphic.BeginUpdate;
try
   TheCanvas:=PGImage1.PixelGraphic.Canvas;
   try
      tc:=GetTickCount; // memorize "time"
      for x := 0 to 255 do
         for y := 0 to 255 do
            TheCanvas.Pixels[x,y]:=rgb(0,x,y);
      tc:=GetTickCount-tc; // calculate time needed
   finally
      FreePGMemoryContexts // this should be called after using a PixelGraphic's Canvas
   end;
finally
   PGImage1.PixelGraphic.EndUpdate;
end;
ShowMessage('Needed '+FloatToStr(tc/1000)+' seconds to set the color of 65636 pixels using TCanvas.Pixels.');
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This should demonstrate the fast Pixels property of TPixelGraphic. ' +
   'Don'#39't confuse it with the slow Pixels property of TCanvas!'#13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

end.
