unit Demo05F;
//
// PixelGraphicLibrary - Demo 5
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface
uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
         PGraphic, Menus;

type
   TForm1 = class (TForm)
    PGImage1: TPGImage;
    PGImage2: TPGImage;
    MainMenu1: TMainMenu;
    PGOpenDialog1: TPGOpenDialog;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    StretchMode1: TMenuItem;
    smFast1: TMenuItem;
    smMedium1: TMenuItem;
    smPrecise1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Changed(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure smFast1Click(Sender: TObject);
    procedure smMedium1Click(Sender: TObject);
    procedure smPrecise1Click(Sender: TObject);
   private
      { Private-Deklarationen }
   public
      { Public-Deklarationen }
   end;

var
   Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
if PGOpenDialog1.Execute then
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
PGImage2.TakePixelGraphic(TPixelGraphic.Create);
PGImage2.PixelGraphic.SetDimension(300, 300, bc24);
Info1Click(Self);
Changed(Self);
end;

procedure TForm1.Changed(Sender: TObject);
begin
PGImage2.PixelGraphic.Erase;
PGImage2.PixelGraphic.StretchDrawRect(
   PGImage2.SelectionLeft, PGImage2.SelectionTop, PGImage2.SelectionWidth, PGImage2.SelectionHeight,
   PGImage1.SelectionLeft, PGImage1.SelectionTop, PGImage1.SelectionWidth, PGImage1.SelectionHeight,
   PGImage1.LendNoModifyPixelGraphic);
end;

procedure TForm1.smFast1Click(Sender: TObject);
begin
PGImage2.PixelGraphic.StretchMode := smFast;
smFast1.Checked:=true;
Changed(self);
end;

procedure TForm1.smMedium1Click(Sender: TObject);
begin
PGImage2.PixelGraphic.StretchMode := smMedium;
smMedium1.Checked:=true;
Changed(self);
end;

procedure TForm1.smPrecise1Click(Sender: TObject);
begin
PGImage2.PixelGraphic.StretchMode := smPrecise;
smPrecise1.Checked:=true;
Changed(self);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This demonstrates the use of TPixelGraphic.StretchDrawRect.'#13#13 +
   'Please select areas of different sizes in the left and the right box. You should also change the StretchMode.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

end.

