unit Demo04F;
//
// PixelGraphicLibrary - Demo 4
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface
uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
         Menus, PGraphic, ComCtrls, ExtCtrls;

type
   TForm1 = class (TForm)
      PGImage1: TPGImage;
      MainMenu1: TMainMenu;
      File1: TMenuItem;
      Info1: TMenuItem;
      Open1: TMenuItem;
      PGOpenDialog1: TPGOpenDialog;
      ZoomFactor1: TMenuItem;
      StretchMode1: TMenuItem;
      StatusBar1: TStatusBar;
      Stretch1: TMenuItem;
      sZoomKAR1: TMenuItem;
      sEnlargeLongerEdgeKAR1: TMenuItem;
      sEnlargeShrinkLongerEdgeKAR1: TMenuItem;
      sShrinkLongerEdgeKAR1: TMenuItem;
      sAlwaysLongerEdgeKAR1: TMenuItem;
      sEnlargeKAR1: TMenuItem;
      sEnlarge1: TMenuItem;
      sShrinkKAR1: TMenuItem;
      sShrink1: TMenuItem;
      sAlwaysKAR1: TMenuItem;
      sAlways1: TMenuItem;
      sNeverKAR1: TMenuItem;
      smFast1: TMenuItem;
      smMedium1: TMenuItem;
      smPrecise1: TMenuItem;
      procedure Open1Click(Sender: TObject);
      procedure Info1Click(Sender: TObject);
      procedure PGImage1ZoomFactorChange(Sender: TObject);
      procedure ZoomFactor1Click(Sender: TObject);
      procedure FormCreate(Sender: TObject);
      procedure HandleStretchMenuClick(Sender: TObject);
      procedure HandleStretchModeMenuClick(Sender: TObject);
   private
      { Private-Deklarationen }
   public
      { Public-Deklarationen }
   end;

var
   Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
   begin
   if PGOpenDialog1.Execute then
      PGImage1.FileName := PGOpenDialog1.FileName;
   end;

procedure TForm1.HandleStretchMenuClick(Sender: TObject);
   begin
   if Sender is TMenuItem then
      TMenuItem(Sender).Checked := true;
   if Sender = sZoomKAR1 then
      PGImage1.Stretch := sZoomKAR;
   if Sender = sEnlargeLongerEdgeKAR1 then
      PGImage1.Stretch := sEnlargeLongerEdgeKAR;
   if Sender = sEnlargeShrinkLongerEdgeKAR1 then
      PGImage1.Stretch := sEnlargeShrinkLongerEdgeKAR;
   if Sender = sShrinkLongerEdgeKAR1 then
      PGImage1.Stretch := sShrinkLongerEdgeKAR;
   if Sender = sAlwaysLongerEdgeKAR1 then
      PGImage1.Stretch := sAlwaysLongerEdgeKAR;
   if Sender = sEnlargeKAR1 then
      PGImage1.Stretch := sEnlargeKAR;
   if Sender = sEnlarge1 then
      PGImage1.Stretch := sEnlarge;
   if Sender = sShrinkKAR1 then
      PGImage1.Stretch := sShrinkKAR;
   if Sender = sShrink1 then
      PGImage1.Stretch := sShrink;
   if Sender = sAlwaysKAR1 then
      PGImage1.Stretch := sAlwaysKAR;
   if Sender = sAlways1 then
      PGImage1.Stretch := sAlways;
   if Sender = sNeverKAR1 then
      PGImage1.Stretch := sNeverKAR;
   end;       

procedure TForm1.PGImage1ZoomFactorChange(Sender: TObject);
   begin
   if StatusBar1 <> nil then
      if PGImage1.UsedZoomFactor > 0 then
         StatusBar1.SimpleText := 'UsedZoomFactor = ' + FloatToStr(PGImage1.
               UsedZoomFactor)
      else
         StatusBar1.SimpleText := 'UsedZoomFactor invalid';
   end;

procedure TForm1.ZoomFactor1Click(Sender: TObject);
   var
      Value: string;

   begin
   if InputQuery('', 'New zoom-factor:', Value) then
      PGImage1.ZoomFactor := StrToFloat(Value);
   end;

procedure TForm1.FormCreate(Sender: TObject);
   begin
   PGImage1ZoomFactorChange(Self);
   Info1Click(Self);
   end;

procedure TForm1.HandleStretchModeMenuClick(Sender: TObject);
   begin
   if Sender is TMenuItem then
      TMenuItem(Sender).Checked := true;
   if Sender = smFast1 then
      PGImage1.StretchMode := smFast;
   if Sender = smMedium1 then
      PGImage1.StretchMode := smMedium;
   if Sender = smPrecise1 then
      PGImage1.StretchMode := smPrecise;
   end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This demonstrates the use of the properties Stretch, StretchMode and ZoomFactor and the event OnZoomFactorChange.'#13#13+
   'Please load pictures of different sizes, play with the size of the application window and try different settings for Stretch, StretchMode and ZoomFactor.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.

