unit FAQ033F1;
//
// PixelGraphicLibrary - FAQ 33
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, Buttons, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Saveas1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PGSaveDialog1: TPGSaveDialog;
    Info1: TMenuItem;
    PGImage1: TPGImage;
    Print1: TMenuItem;
    PickPaletteColor1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure PickPaletteColor1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses FAQ033F2;

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
PGOpenDialog1.Filename:=PGImage1.Filename;
if PGOpenDialog1.Execute then
   PGImage1.Filename:=PGOpenDialog1.Filename;
Saveas1.Enabled:=not PGImage1.Empty;
Print1.Enabled:=not PGImage1.Empty;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
PGSaveDialog1.Filename:=PGImage1.Filename;
if PGSaveDialog1.Execute then
   PGImage1.SaveToFile(PGSaveDialog1.Filename);             
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
PGImage1.LendPixelGraphic.Print(true, true, self);
end;

procedure TForm1.PickPaletteColor1Click(Sender: TObject);
var
   OrigPG, PalettePG: TPixelGraphic;
   oldPaletteIndex: Integer;
   i, x, y: Integer;
   aRect: TRect;
begin
if PGImage1.Empty then
   raise Exception.Create('You must load a graphic with a palette');
OrigPG:=PGImage1.LendNoModifyPixelGraphic;
if (OrigPG.BitCount>bc8) or (OrigPG.NumPaletteEntries<1) then
   raise Exception.Create('This graphic does not contain a palette');
oldPaletteIndex:=Form2.PaletteIndex;
if Form2.PaletteIndex>OrigPG.NumPaletteEntries-1 then
   Form2.PaletteIndex:=0;
PalettePG:=TPixelGraphic.Create;
try
   PalettePG.SetDimension(Form2.PGImage1.ClientWidth, Form2.PGImage1.ClientHeight, bc8);
   PalettePG.CopyPalette(OrigPG);
   PalettePG.BackGroundColor:=ColorToRGB(clBtnFace);
   PalettePG.Erase;
   try
      for i:=0 to PalettePG.NumPaletteEntries-1 do
         begin
         aRect.left:=(i mod 16) * (PalettePG.width - 1) div 16;
         aRect.top:=(i div 16) * (PalettePG.height - 1) div 16;
         aRect.right:=((i mod 16) + 1) * (PalettePG.width - 1) div 16 + 1;
         aRect.bottom:=(i div 16 + 1) * (PalettePG.height - 1) div 16 + 1;
         for y:=aRect.top to aRect.bottom-1 do
            for x:=aRect.left to aRect.right-1 do
               PalettePG.Bits[x,y]:=i;
         PalettePG.Canvas.Brush.Color:=clBlack;
         PalettePG.Canvas.Brush.Style:=bsSolid;
         PalettePG.Canvas.FrameRect(aRect);
         end;
      Form2.PGImage1.TakePixelGraphic(PalettePG);
   finally
      FreePGMemoryContexts;
   end;
except
   PalettePG.Free;
end;
if Form2.ShowModal=mrOK then
   ShowMessage('Selected PaletteIndex: '+IntToStr(Form2.PaletteIndex)+#13+'Selected RGB: $'+IntToHex(OrigPG.PaletteEntries[Form2.PaletteIndex],8))
else
   Form2.PaletteIndex:=oldPaletteIndex;
end;

procedure TForm1.Info1Click(Sender: TObject);
// Set application title and show the info-message
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I implement a dialog to pic a color from a PixelGraphic'#39's palette?'#13#13+
   'Answer: Look at this... Load a graphic with a palette and select Pic-Palette-Color from the menu!'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;


end.
