unit FAQ030F;
//
// PixelGraphicLibrary - FAQ 30
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus;

type
  TForm1 = class(TForm)
    PGImage1: TPGImage;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PGImage1PicBoxOnMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PGImage1PicBoxOnMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure PGImage1Painting(Sender: TObject);
    procedure PGImage1Paint(Sender: TObject);
    procedure PGImage1PicBoxOnMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PGImage1PicBoxOnSetCursor(Sender: TObject;
      var CursorHandle: Integer);
    procedure Info1Click(Sender: TObject);
  private
    { Private declarations }
    FSpritePixelGraphic: TPixelGraphic;
    FSpriteMaskPixelGraphic: TPixelGraphic;
    FSpritePaintPixelGraphic: TPixelGraphic;
    FSpriteRestorePixelGraphic: TPixelGraphic;
    FSpriteX: Integer;
    FSpriteY: Integer;
    FSpriteOffSetX: Integer;
    FSpriteOffSetY: Integer;
    FSpriteMoving: Boolean;
    procedure SpriteMoveTo(PicBoxX, PicBoxY: Integer);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function min(Int1, Int2: Integer): Integer;
   begin
   if Int1<Int2 then
      result:=Int1
   else
      result:=Int2;
   end;

function max(Int1, Int2: Integer): Integer;
   begin
   if Int1>Int2 then
      result:=Int1
   else
      result:=Int2;
   end;

const
   TransparentColor=clBlack;
   Tolerance=60;

procedure TForm1.FormCreate(Sender: TObject);
var
   x, y: Integer;
   aColor: TRGB;
begin
FSpritePixelGraphic:=TPixelGraphic.Create;
FSpritePixelGraphic.LoadFromFile('FAQ030.jpg');
// Create a mask; use bc8, because single bytes can be accessed easily
FSpriteMaskPixelGraphic:=TPixelGraphic.Create;
FSpriteMaskPixelGraphic.SetDimension(FSpritePixelGraphic.Width,FSpritePixelGraphic.Height, bc8);
for y:=0 to FSpritePixelGraphic.Height-1 do
   for x:=0 to FSpritePixelGraphic.Width-1 do
      begin
      aColor:=FSpritePixelGraphic.Pixels[x,y];
      if Abs(max(max(
         GetRValue(aColor)-GetRValue(TransparentColor),
         GetGValue(aColor)-GetGValue(TransparentColor)),
         GetBValue(aColor)-GetBValue(TransparentColor)))<=Tolerance then
         FSpriteMaskPixelGraphic.Bits[x,y]:=0
      else
         FSpriteMaskPixelGraphic.Bits[x,y]:=255;
      end;
FSpritePaintPixelGraphic:=TPixelGraphic.Create;
FSpriteRestorePixelGraphic:=TPixelGraphic.Create;
FSpriteX:=0;
FSpriteY:=0;
FSpriteOffSetX:=0;
FSpriteOffSetY:=0;
FSpriteMoving:=false;
Info1Click(Self);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
FSpritePixelGraphic.Free;
FSpriteMaskPixelGraphic.Free;
FSpritePaintPixelGraphic.Free;
FSpriteRestorePixelGraphic.Free;
end;

procedure TForm1.SpriteMoveTo(PicBoxX, PicBoxY: Integer);
var SpriteRect: TRect;
begin
SpriteRect:=Rect(PGImage1.PicBox.Left+FSpriteX, PGImage1.PicBox.Top+FSpriteY, PGImage1.PicBox.Left+FSpriteX+FSpritePixelGraphic.Width, PGImage1.PicBox.Top+FSpriteY+FSpritePixelGraphic.Height);
InvalidateRect(PGImage1.Handle, @SpriteRect, false);
FSpriteX:=PicBoxX+FSpriteOffSetX;
FSpriteY:=PicBoxY+FSpriteOffSetY;
SpriteRect:=Rect(PGImage1.PicBox.Left+FSpriteX, PGImage1.PicBox.Top+FSpriteY, PGImage1.PicBox.Left+FSpriteX+FSpritePixelGraphic.Width, PGImage1.PicBox.Top+FSpriteY+FSpritePixelGraphic.Height);
InvalidateRect(PGImage1.Handle, @SpriteRect, false);
PGImage1.Update;
end;

procedure TForm1.PGImage1PicBoxOnMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
if (ssLeft in Shift) and (FSpriteMaskPixelGraphic.Bits[X-FSpriteX, Y-FSpriteY] <>0) then
   begin
   FSpriteOffSetX:=FSpriteX-X;
   FSpriteOffSetY:=FSpriteY-Y;
   SpriteMoveTo(X, Y);
   FSpriteMoving:=true;
   end;
end;

procedure TForm1.PGImage1PicBoxOnMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
if FSpriteMoving then
   SpriteMoveTo(X, Y);
end;

procedure TForm1.PGImage1PicBoxOnMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
FSpriteMoving:=false;
end;

function ColorSettingsIdentical(PG1, PG2: TPixelGraphic): Boolean;
   var i: Integer;
   begin
   result:=PG1.BitCount=PG2.BitCount;
   if result and (PG1.BitCount<bc24) then
      begin
      result:=result and (PG1.NumPaletteEntries=PG2.NumPaletteEntries);
      if result and (PG1.NumPaletteEntries>0) then
         for i:=0 to PG1.NumPaletteEntries-1 do
            result:=result and (PG1.PaletteEntries[i]=PG2.PaletteEntries[i]);
      end;
   end;

procedure TForm1.PGImage1Painting(Sender: TObject);
var
   PGImagePixelGraphicToUse: TPixelGraphic;
   SpritePixelGraphicToUse: TPixelGraphic;
   FirstX, LastX, FirstY, LastY: Integer;
   BytesPerPixel: Integer;
   x, y: Integer;
   PGImagePixelGraphicToUseBytePointer: PByte;
   SpritePixelGraphicToUseBytePointer: PByte;
   FSpriteMaskPixelGraphicBytePointer: PByte;
   i: Integer;
begin
if PGImage1.PaintPixelGraphic<>nil then
   PGImagePixelGraphicToUse:=PGImage1.PaintPixelGraphic // PGImage will display PaintPixelGraphic!
else
   PGImagePixelGraphicToUse:=PGImage1.LendNoModifyPixelGraphic; // PGImage will display PaintPixelGraphic! No Modify! We will undo changes in OnPaint!
// Make shure that we have a Restore PixelGraphic with BitCount of the PixelGraphic PGImage displays and the size of the sprite
if (FSpriteRestorePixelGraphic.BitCount<>PGImagePixelGraphicToUse.BitCount)
   or (FSpriteRestorePixelGraphic.Width<>FSpritePixelGraphic.Width)
   or (FSpriteRestorePixelGraphic.Height<>FSpritePixelGraphic.Height) then
   FSpriteRestorePixelGraphic.SetDimension(FSpritePixelGraphic.Width, FSpritePixelGraphic.Height, PGImagePixelGraphicToUse.BitCount);
// the following values are needed for clipping
FirstY:=max(-FSpriteY ,0);
LastY:=min(PGImagePixelGraphicToUse.Height-FSpriteY-1, FSpritePixelGraphic.Height-1);
FirstX:=max(-FSpriteX ,0);
LastX:=min(PGImagePixelGraphicToUse.Width-FSpriteX-1, FSpritePixelGraphic.Width-1);
BytesPerPixel:=FSpriteRestorePixelGraphic.BitCountNum div 8;
// Save the area covered by the sprite in the Restore PixelGraphic, so we can undo changes in OnPaint
if (FirstY<=LastY) and (FirstX<=LastX) then
   // copy the bits from the PixelGraphic PGImages displays into the Restore PixelGraphic, so we can undo the changes in OnPaint
   if FSpriteRestorePixelGraphic.BitCount>=bc8 then
      for y:=FirstY to LastY do
         Move(Pointer(Integer(PGImagePixelGraphicToUse.ScanLineBytes[y+FSpriteY])+(FSpriteX+FirstX)*BytesPerPixel)^,Pointer(Integer(FSpriteRestorePixelGraphic.ScanLineBytes[y])+FirstX*BytesPerPixel)^,(LastX-FirstX+1)*BytesPerPixel)
   else
      for y:=FirstY to LastY do
         for x:=FirstX to LastX do
            FSpriteRestorePixelGraphic.Bits[x,y]:=PGImagePixelGraphicToUse.Bits[x+FSpriteX,y+FSpriteY];
// Now make shure that we have a PixelGraphic with the sprite that has exactly the same color settings like PixelGraphic PGImages displays, if the one we have doesn't then make one
if ColorSettingsIdentical(FSpritePixelGraphic, PGImagePixelGraphicToUse) then
   SpritePixelGraphicToUse:=FSpritePixelGraphic
else
   begin
   if (not ColorSettingsIdentical(FSpritePaintPixelGraphic, PGImagePixelGraphicToUse))
      or (FSpritePaintPixelGraphic.Width<>FSpritePixelGraphic.Width)
      or (FSpritePaintPixelGraphic.Height<>FSpritePixelGraphic.Height) then
      begin
      FSpritePaintPixelGraphic.SetDimension(FSpritePixelGraphic.Width, FSpritePixelGraphic.Height, PGImagePixelGraphicToUse.BitCount);
      if FSpritePaintPixelGraphic.BitCount<bc24 then
         FSpritePaintPixelGraphic.CopyPalette(PGImagePixelGraphicToUse);
      FSpritePaintPixelGraphic.StretchDraw(FSpritePixelGraphic);
      end;
   SpritePixelGraphicToUse:=FSpritePaintPixelGraphic;
   end;
// Here we have the Sprite in SpritePixelGraphicToUse which has the same color settings like PGImagePixelGraphicToUse and we have the transparency mask in FSpriteMaskPixelGraphic
// All we need to do now is copy the not transparent Bits from SpritePixelGraphicToUse into PGImagePixelGraphicToUse
if (FirstY<=LastY) and (FirstX<=LastX) then
   if FSpriteRestorePixelGraphic.BitCount>=bc8 then
      for y:=FirstY to LastY do
         begin
         PGImagePixelGraphicToUseBytePointer:=Pointer(Integer(PGImagePixelGraphicToUse.ScanLineBytes[y+FSpriteY])+(FSpriteX+FirstX)*BytesPerPixel);
         SpritePixelGraphicToUseBytePointer:=Pointer(Integer(SpritePixelGraphicToUse.ScanLineBytes[y])+FirstX*BytesPerPixel);
         FSpriteMaskPixelGraphicBytePointer:=Pointer(Integer(FSpriteMaskPixelGraphic.ScanLineBytes[y])+FirstX);
         for x:=FirstX to LastX do
            begin
            for i:=1 to BytesPerPixel do
               begin
               if FSpriteMaskPixelGraphicBytePointer^<>0 then
                  PGImagePixelGraphicToUseBytePointer^:=SpritePixelGraphicToUseBytePointer^;
               inc(PGImagePixelGraphicToUseBytePointer);
               inc(SpritePixelGraphicToUseBytePointer);
               end;
            inc(FSpriteMaskPixelGraphicBytePointer);
            end;
         end
   else
      for y:=FirstY to LastY do
         begin
         FSpriteMaskPixelGraphicBytePointer:=Pointer(Integer(FSpriteMaskPixelGraphic.ScanLineBytes[y])+FirstX);
         for x:=FirstX to LastX do
            begin
            if FSpriteMaskPixelGraphicBytePointer^<>0 then
               PGImagePixelGraphicToUse.Bits[x+FSpriteX,y+FSpriteY]:=SpritePixelGraphicToUse.Bits[x,y];
            inc(FSpriteMaskPixelGraphicBytePointer);
            end;
         end;
end;

procedure TForm1.PGImage1Paint(Sender: TObject);
var
   PGImagePixelGraphicToUse: TPixelGraphic;
   FirstX, LastX, FirstY, LastY: Integer;
   BytesPerPixel: Integer;
   x, y: Integer;
begin
if PGImage1.PaintPixelGraphic<>nil then
   PGImagePixelGraphicToUse:=PGImage1.PaintPixelGraphic // PGImage will display PaintPixelGraphic!
else
   PGImagePixelGraphicToUse:=PGImage1.LendNoModifyPixelGraphic; // PGImage will display PaintPixelGraphic! No Modify! We will undo changes in OnPaint!
// the following values are needed for clipping
FirstY:=max(-FSpriteY ,0);
LastY:=min(PGImagePixelGraphicToUse.Height-FSpriteY-1, FSpritePixelGraphic.Height-1);
FirstX:=max(-FSpriteX ,0);
LastX:=min(PGImagePixelGraphicToUse.Width-FSpriteX-1, FSpritePixelGraphic.Width-1);
BytesPerPixel:=FSpriteRestorePixelGraphic.BitCountNum div 8;
// Save the area covered by the sprite in the Restore PixelGraphic, so we can undo changes in OnPaint
if (FirstY<=LastY) and (FirstX<=LastX) then
   // copy the bits from the PixelGraphic PGImages displays into the Restore PixelGraphic, so we can undo the changes in OnPaint
   if FSpriteRestorePixelGraphic.BitCount>=bc8 then
      for y:=FirstY to LastY do
         Move(Pointer(Integer(FSpriteRestorePixelGraphic.ScanLineBytes[y])+FirstX*BytesPerPixel)^,Pointer(Integer(PGImagePixelGraphicToUse.ScanLineBytes[y+FSpriteY])+(FSpriteX+FirstX)*BytesPerPixel)^,(LastX-FirstX+1)*BytesPerPixel)
   else
      for y:=FirstY to LastY do
         for x:=FirstX to LastX do
            PGImagePixelGraphicToUse.Bits[x+FSpriteX,y+FSpriteY]:=FSpriteRestorePixelGraphic.Bits[x,y];
end;

procedure TForm1.PGImage1PicBoxOnSetCursor(Sender: TObject;
  var CursorHandle: Integer);
var aPoint: TPoint;
begin
GetCursorPos(aPoint);
aPoint:=PGImage1.PicBox.ScreenToClient(aPoint);
if FSpriteMaskPixelGraphic.Bits[aPoint.X-FSpriteX, aPoint.Y-FSpriteY] <>0 then
   CursorHandle:=MoveSelCursor;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: I need a fast Sprite effect. The user of my application should be '+
   'able to move a sprite that has to be transparent in some parts around on '+
   'a PGImage. I need a fast solution that does not cause to much flickering.'#13#13+
   'Answer: Have a look at this... Note that this code is hard to understand... '+
   'Performance will be the best if the system and the background graphic have '+
   'at least 8 bits per pixel. This will not work with zooming, tiling, mirroring... '+
   'UseThread must be false.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.

{
Here is another question I was asked: I must move several elements on one
PGImage, may I ask you an advice?

I would encapsulate all the variables and functions in a class. I would create
an instance for each sprite... So you should have less mess and a lot less
code...

If you want more sprites on one PGImage I would do the following:

Create a list (TList) put the pointers to the instances of the sprite class
into the list - for each sprite one pointer...

Now there will be the tricky thing:

* You must handle the sprites in OnPaint (where you undo the changes) in
  exactly the opposite order like you did in OnPainting (where you save the
  background and draw the sprite)... That's important because there might be
  a sprite moving over another... Imagine the sprites in a order like windows
  on Windows' desktop: In OnPainting you should draw the bottom sprite first...
  In OnPaint you should undo the bottom sprite as last...

* When you check for mouse hits in a sprite you should check the top sprite
  first and exit the loop when you got a hit...

* To get a good performance when you have something like 10 sprites on a
  PGImage you should see in OnPainting if the Sprite is partly inside the
  Update-Region (I think I would use a call to GetUpdateRect (see Win32 API)
  using the Handle of PGImage as window handle). Do the stuff that has to be
  done for a sprite in OnPainting only if the sprite is partly inside...
  Memorize in your sprite class if you handled that sprite in OnPainting and
  do the stuff in OnPaint for that sprite only if you handled that sprite in
  OnPainting...

  I never tryed it! Good Luck...
  }

