unit FAQ028F;
//
// PixelGraphicLibrary - FAQ 28
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, ExtCtrls, PGraphic, Menus;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    SrcDriveComboBox: TDriveComboBox;
    SrcDirectoryListBox: TDirectoryListBox;
    SrcFileListBox: TFileListBox;
    DestDriveComboBox: TDriveComboBox;
    DestDirectoryListBox: TDirectoryListBox;
    DestFileNameEdit: TEdit;
    GoButton: TButton;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    Bevel1: TBevel;
    procedure GoButtonClick(Sender: TObject);
    procedure Info1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.GoButtonClick(Sender: TObject);
var
   FullName: string;
   TIFFileFormatWriter:TTIFFileFormatWriter;
   PixelGraphic: TPixelGraphic;
   FileStream: TFileStream;
   i, aCounter: Integer;
begin
aCounter:=0;
if SrcFileListBox.Items.Count>0 then
   for i:=0 to SrcFileListBox.Items.Count-1 do
      if SrcFileListBox.Selected[i] then
         Inc(aCounter);
if aCounter=0 then
   ShowMessage('You must select some files from the file list!')
else
   begin
   FullName:=DestDirectoryListBox.Directory+'\'+Trim(DestFileNameEdit.Text);
   if (UpperCase(ExtractFileExt(FullName))<>'.TIF') and (UpperCase(ExtractFileExt(FullName))<>'.TIFF') then
      ShowMessage('Extension of file to create must be tif or tiff!')
   else
      if (not FileExists(FullName)) or (MessageDlg('Overwrite existing file '+FullName,mtConfirmation,mbYesNoCancel,0)=mrYes) then
         begin
         FileStream:=TFileStream.Create(FullName, fmCreate);
         try
            TIFFileFormatWriter:=TTIFFileFormatWriter.Create;
            try
               PixelGraphic:= TPixelGraphic.Create;
               try
                  TIFFileFormatWriter.BeginWriteToStream(FileStream);
                  try
                     for i:=0 to SrcFileListBox.Items.Count-1 do
                        if SrcFileListBox.Selected[i] then
                           begin
                           PixelGraphic.LoadFromFile(SrcDirectoryListBox.Directory+'\'+SrcFileListBox.Items.strings[i]);
                           TIFFileFormatWriter.AppendToStream(FileStream, PixelGraphic);
                           end;
                  finally
                     TIFFileFormatWriter.EndWriteToStream(FileStream);
                  end;
               finally
                  PixelGraphic.Free;
               end;
            finally
               TIFFileFormatWriter.Free;
            end;
         finally
            FileStream.Free;
         end;
         end;
      end;
   end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I generate multi image TIFF files?'#13#13 +
   'Answer: Have a look at this... '+
   'Select some files in the left file list, enter a TIFF file name '+
   'in the right file name edit and press the ">>" button. '+
   'Use the FAQ027 application to have a look at the generated file. '+
   'Note that uncompressed multi image TIFF files can become pretty large, '+
   'so you might want to delete the file you created while experimenting with this application.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
