unit FAQ022F;
//
// PixelGraphicLibrary - FAQ 22
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    PGImage: TPGImage;
    Image: TImage;
    OpenandloadintoImage1: TMenuItem;
    OpenDialog: TOpenDialog;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure OpenandloadintoImage1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImage.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.OpenandloadintoImage1Click(Sender: TObject);
begin
IF OpenDialog.Execute then
   begin
   Update;
   Image.Picture.LoadFromFile(OpenDialog.FileName);
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
if PGImage.LendNoModifyPixelGraphic<>nil then
   PGImage.LendNoModifyPixelGraphic.SaveToBitmap(Image.Picture.Bitmap);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   aPG: TPixelGraphic;
begin
aPG:=TPixelGraphic.Create;
try
   aPG.LoadFromBitmap(Image.Picture.Bitmap);
   PGImage.TakePixelGraphic(aPG);
except
   aPG.Free;
   raise;
end;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
PaletteChanged(true);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I get a picture from a PGImage component into a TImage component and '+
   'how can I get a picture from a TImage component into a PGImage component?'#13#13 +
   'Answer: You can use a TPixelGraphic.SaveToBitmap and TPixelGraphic.LoadFromBitmap.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;


end.
