unit FAQ021F;
//
// PixelGraphicLibrary - FAQ 21
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    Save1: TMenuItem;
    PGSaveDialog1: TPGSaveDialog;
    PGImage1: TPGImage;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure PGImage1PicBoxOnPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImage1.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.PGImage1PicBoxOnPaint(Sender: TObject);
begin
PGImage1.PicBox.Canvas.Brush.Color:=clRed;
PGImage1.PicBox.Canvas.Ellipse(PGImage1.PicBox.Width div 4, PGImage1.PicBox.Height div 4, 3*PGImage1.PicBox.Width div 4, 3*PGImage1.PicBox.Height div 4);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: I would like to draw something over a TPixelGraphic that is displayed in a TPGImage. I don'#39't want to "hurt" the graphic because I want to save it later. How can I do this?'#13#13+
   'Answer: Use the event TGPImage.PicBoxOnPaint and the property TGPImage.PicBox.Canvas.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

end.
