unit FAQ020F1;
//
// PixelGraphicLibrary - FAQ 20
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    Save1: TMenuItem;
    PGSaveDialog1: TPGSaveDialog;
    PGImage1: TPGImage;
    Options1: TMenuItem;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Options1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses FAQ020F2;

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImage1.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: Is there a way to control jpeg quality/compression...?'#13#13+
   'Answer: Here is an example.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

procedure TForm1.Options1Click(Sender: TObject);
begin
with Form2 do
   begin
   JPEGWIntFastRB.Checked := JPEGCompMethod = jmIntFast;
   JPEGWIntPreciseRB.Checked := JPEGCompMethod = jmIntPrecise;
   JPEGWFloatRB.Checked := JPEGCompMethod = jmFloat;
   JPEGWQualityEdit.Text := IntToStr(Integer(JPEGCompQuality));
   JPEGWProgressiveCB.Checked:=JPEGCompProgressive;
   JPEGRIntFastRB.Checked := JPEGDecompMethod = jmIntFast;
   JPEGRIntPreciseRB.Checked := JPEGDecompMethod = jmIntPrecise;
   JPEGRFloatRB.Checked := JPEGDecompMethod = jmFloat;
   PXMBinaryRB.Checked := PXMWriteBinary;
   PXMASCIIRB.Checked := not PXMWriteBinary;
   TIFFCompNoneRB.Checked:=TIFFWriteCompression=tcUncompressed;
   TIFFCompPackBitsRB.Checked:=TIFFWriteCompression=tcPackBits;
   TIFFByteOrderIRB.Checked:=TIFFWriteByteOrder=tboI;
   TIFFByteOrderMRB.Checked:=TIFFWriteByteOrder=tboM;
   TIFFRGBRB.Checked:=TIFFWriteTrueColorPhotInterpret=ttcpiRGB;
   TIFFCMYKRB.Checked:=TIFFWriteTrueColorPhotInterpret=ttcpiCMYK;
   TIFFBlackIsZeroRB.Checked:=TIFFWriteGrayScalePhotInterpret=tgspiBlackIsZero;
   TIFFWhiteIsZeroRB.Checked:=TIFFWriteGrayScalePhotInterpret=tgspiWhiteIsZero;
   TIFFResNoneRB.Checked:=TIFFWriteResolutionUnit=truNone;
   TIFFResInchRB.Checked:=TIFFWriteResolutionUnit=truInch;
   TIFFResCentimeterRB.Checked:=TIFFWriteResolutionUnit=truCentimeter;
   TIFFResHorizNEdit.Text:=IntToStr(TIFFWriteXResolutionNumerator);
   TIFFResHorizDEdit.Text:=IntToStr(TIFFWriteXResolutionDenominator);
   TIFFResVertNEdit.Text:=IntToStr(TIFFWriteYResolutionNumerator);
   TIFFResVertDEdit.Text:=IntToStr(TIFFWriteYResolutionDenominator);
   WriteGammaCB.Checked := WriteGamma;
   ScreenGammaEdit.Text:=FloatToStr(ScreenGamma);
   GammaCorrectionOnReadCB.Checked := GammaCorrectionOnRead;
   if ShowModal=mrOK then
      begin
      if JPEGWIntFastRB.Checked then
         JPEGCompMethod := jmIntFast;
      if JPEGWIntPreciseRB.Checked then
         JPEGCompMethod := jmIntPrecise;
      if JPEGWFloatRB.Checked then
         JPEGCompMethod := jmFloat;
      JPEGCompQuality := TJPEGCompQuality(StrToInt(JPEGWQualityEdit.Text));
      JPEGCompProgressive:=JPEGWProgressiveCB.Checked;
      if JPEGRIntFastRB.Checked then
         JPEGDecompMethod := jmIntFast;
      if JPEGRIntPreciseRB.Checked then
         JPEGDecompMethod := jmIntPrecise;
      if JPEGRFloatRB.Checked then
         JPEGDecompMethod := jmFloat;
      PXMWriteBinary:=PXMBinaryRB.Checked;
      if TIFFCompNoneRB.Checked then
         TIFFWriteCompression:=tcUncompressed;
      if TIFFCompPackBitsRB.Checked then
         TIFFWriteCompression:=tcPackBits;
      if TIFFByteOrderIRB.Checked then
         TIFFWriteByteOrder:=tboI;
      if TIFFByteOrderMRB.Checked then
         TIFFWriteByteOrder:=tboM;
      if TIFFRGBRB.Checked then
         TIFFWriteTrueColorPhotInterpret:=ttcpiRGB;
      if TIFFCMYKRB.Checked then
         TIFFWriteTrueColorPhotInterpret:=ttcpiCMYK;
      if TIFFBlackIsZeroRB.Checked then
         TIFFWriteGrayScalePhotInterpret:=tgspiBlackIsZero;
      if TIFFWhiteIsZeroRB.Checked then
         TIFFWriteGrayScalePhotInterpret:=tgspiWhiteIsZero;
      if TIFFResNoneRB.Checked then
         TIFFWriteResolutionUnit:=truNone;
      if TIFFResInchRB.Checked then
         TIFFWriteResolutionUnit:=truInch;
      if TIFFResCentimeterRB.Checked then
         TIFFWriteResolutionUnit:=truCentimeter;
      TIFFWriteXResolutionNumerator:=StrToInt(TIFFResHorizNEdit.Text);
      TIFFWriteXResolutionDenominator:=StrToInt(TIFFResHorizDEdit.Text);
      TIFFWriteYResolutionNumerator:=StrToInt(TIFFResVertNEdit.Text);
      TIFFWriteYResolutionDenominator:=StrToInt(TIFFResVertDEdit.Text);
      WriteGamma:=WriteGammaCB.Checked;
      ScreenGamma:=StrToFloat(ScreenGammaEdit.Text);
      GammaCorrectionOnRead:=GammaCorrectionOnReadCB.Checked;
      end;
   end;
end;

end.
