unit FAQ017F;
//
// PixelGraphicLibrary - FAQ 17
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Saveas1: TMenuItem;
    PGSaveDialog1: TPGSaveDialog;
    PGImage1: TPGImage;
    Panel1: TPanel;
    CaptureButton: TButton;
    ClearButton: TButton;
    procedure Info(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure CaptureButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CaptureButtonClick(Sender: TObject);
var
   ScreenDC: HDC;
   ScreenDCBitCount: Integer;
   aPG: TPixelGraphic;
   aLogPalette: PLogPalette;
   i: Integer;
begin
ScreenDC:=GetDC(0);
try
   ScreenDCBitCount := (GetDeviceCaps(ScreenDC,BITSPIXEL) * GetDeviceCaps(ScreenDC, PLANES));
   aPG:=TPixelGraphic.Create;
   try
      case ScreenDCBitCount of
         4:
            begin
            aPG.SetDimension(Screen.Width, Screen.Height, bc4);
            aPG.PaletteKind:=pSys16;
            end;
         8: // the system palette has to be copied to the PixelGraphic when running in 256 color mode
            begin
            aPG.SetDimension(Screen.Width, Screen.Height, bc8);
            aLogPalette := AllocMem(SizeOf(TLogPalette) + 256 * SizeOf(TPaletteEntry));
            try
               aLogPalette.palVersion := $300;
               aLogPalette.palNumEntries := 256;
               GetSystemPaletteEntries(ScreenDC, 0, 256, aLogPalette.palPalEntry);
               aPG.NumPaletteEntries:=256;
               for i:=0 to 255 do
                  aPG.PaletteEntries[i]:=(Integer(aLogPalette.palPalEntry[i]) and $00FFFFFF);
            finally
               FreeMem(aLogPalette);
            end; // of try/finally
            end;
      else
         aPG.SetDimension(Screen.Width, Screen.Height, bc24);
      end; // of case
      StretchBlt(aPG.Canvas.Handle, 0, 0, aPG.Width, aPG.Height, ScreenDC, 0, 0, Screen.Width, Screen.Height, SRCCopy);
      FreePGMemoryContexts; // always call this after having finished accessing a TPixelGraphic.Canvas in a procedure
      PGImage1.TakePixelGraphic(aPG);
      SaveAs1.Enabled:=true;
      CaptureButton.Enabled:=false;
      ClearButton.Enabled:=true;
   except
      aPG.Free;
   end; // of try/except
finally
   ReleaseDC(0, ScreenDC);
end; // of try/finally
end;

procedure TForm1.ClearButtonClick(Sender: TObject);
begin
PGImage1.PixelGraphic:=nil;
SaveAs1.Enabled:=false;
CaptureButton.Enabled:=true;
ClearButton.Enabled:=false;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
if PGSaveDialog1.Execute then
   PGImage1.SaveToFile(PGSaveDialog1.FileName);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: I would like to capture the contents of the screen to a PixelGraphic. '+
   'Do you have an example?'#13#13+
   'Answer: Here it comes...'#13#13+
   'Note: You should try to avoid that the screen capturing application uses '+
   'palette entries in the foreground window while capturing the screen in '+
   '256 color mode.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
