unit FAQ016F;
//
// PixelGraphicLibrary - FAQ 16
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    Label1: TLabel;
    procedure Info(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
var
   ScreenDC: HDC;
   DCBitCount: Integer;
begin
ScreenDC:=GetDC(0);
try
   DCBitCount := (GetDeviceCaps(ScreenDC,BITSPIXEL)*GetDeviceCaps(ScreenDC, PLANES));
finally
   ReleaseDC(0, ScreenDC);
end; // of try/finally
//
// That will give you the Bits per Pixel. Note that the result will be 32
// on some machines. So you will get troubles when you want to calculate
// the number of colors:
//
// NumColors:=1 shl DCBitCount;
//
Label1.Caption:='The color resolution of the display driver is '+IntToStr(DCBitCount)+' bits per pixel.'
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I determine the color resolution of the display driver?'#13#13 +
   'Answer: Use the Windows API function GetDeviceCaps.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
