unit FAQ015F;
//
// PixelGraphicLibrary - FAQ 15
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    Save1: TMenuItem;
    PGSaveDialog1: TPGSaveDialog;
    Panel1: TPanel;
    Button1: TButton;
    PGImage1: TPGImage;
    RGBFilterDialog1: TRGBFilterDialog;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Button1.Enabled:=false;
   Update;
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
   PGImage1.SelectionTop:=PGImage1.LendNoModifyPixelGraphic.Height div 4;
   PGImage1.SelectionHeight:=PGImage1.LendNoModifyPixelGraphic.Height div 4;
   PGImage1.SelectionLeft:=PGImage1.LendNoModifyPixelGraphic.Width div 4;
   PGImage1.SelectionWidth:=PGImage1.LendNoModifyPixelGraphic.Width div 4;
   PGImage1.Selection:=true;
   Button1.Enabled:=true;
   end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImage1.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
   FilterPG: TPixelGraphic;
begin
FilterPG:=TPixelGraphic.Create;
try
   FilterPG.SetDimension(PGImage1.SelectionWidth, PGImage1.SelectionHeight, bc24);
   FilterPG.DrawRect(0,0,PGImage1.SelectionWidth, PGImage1.SelectionHeight, PGImage1.SelectionLeft, PGImage1.SelectionTop, PGImage1.LendNoModifyPixelGraphic);
   if RGBFilterDialog1.Execute(FilterPG) then
      begin
      Update;
      FilterPG.ApplyFilter(RGBFilterDialog1.Filter, FilterPG);
      PGImage1.PixelGraphic.DrawRect(PGImage1.SelectionLeft, PGImage1.SelectionTop,PGImage1.SelectionWidth, PGImage1.SelectionHeight,0,0,FilterPG);
      end
finally
   FilterPG.Free;
end; // of try/finally
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: I would like to perform a RGB filter operation only to a rectangular area. How can this be done?'#13#13+
   'Answer: Here is an example.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

end.
