unit FAQ009F;
//
// PixelGraphicLibrary - FAQ 9
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    SaveResult1: TMenuItem;
    PGImageResult: TPGImage;
    PGImageSource: TPGImage;
    PGSaveDialog1: TPGSaveDialog;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure SaveResult1Click(Sender: TObject);
    procedure PGImageSourcePixelGraphicChange(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
IF PGOpenDialog1.Execute then
   begin
   Update;
   PGImageSource.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.SaveResult1Click(Sender: TObject);
begin
IF PGSaveDialog1.Execute then
   begin
   Update;
   PGImageResult.SaveToFile(PGSaveDialog1.FileName);
   end;
end;

procedure TForm1.PGImageSourcePixelGraphicChange(Sender: TObject);
var
   SourcePG: TPixelGraphic;
   ResultPG: TPixelGraphic;

begin
SourcePG:=PGImageSource.LendNoModifyPixelGraphic;
ResultPG:=TPixelGraphic.Create;
ResultPG.SetDimension(SourcePG.Width, SourcePG.Height, bc8);
ResultPG.PaletteKind:=pGray256;
ResultPG.Dither:=false; // Dithering costs time and will not improve quality on a bc8 pGray256 PixelGraphic
// You might want to alter the setting for ResultPG.RGBWeighting here
ResultPG.StretchDraw(SourcePG);
PGImageResult.TakePixelGraphic(ResultPG);
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
PaletteChanged(true);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: How can I create a grayscaled PixelGraphic from a color PixelGraphic using StretchDraw?'#13#13 +
   'Answer: Create a second PixelGraphic with same width and height and BitCount=bc8. '+
   'Set PaletteKind to pGray256. Set Dither to false to gain some speed. '+
   'StretchDraw the first on the second PixelGraphic.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
