unit FAQ003F;
//
// PixelGraphicLibrary - FAQ 3
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus;

type
  TForm1 = class(TForm)
    PGImage1: TPGImage;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    PixelGraphicLibraryFAQ0031: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Info(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
{$R FAQ003F.RES}

procedure TForm1.FormCreate(Sender: TObject);
var
   aResourceStream: TResourceStream;
   aPG: TPixelGraphic;
begin
aResourceStream:=TResourceStream.Create(HInstance, 'JPG_1', 'JPG');
try
   aPG:=TPixelGraphic.Create;
   aPG.LoadFromStream(aResourceStream);
   PGImage1.TakePixelGraphic(aPG);
finally
   aResourceStream.Free;
end;
Info(Self);
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: Do you have a sample of loading a JPG file from a resource file '+
   'and then assigning it to a TPixelGraphic?' + #13#13 +
   'Answer: Yes, here it comes.'+#13#13+
   'Note: The resource file was created using Borland'#39's Resource Workshop '+
   '4.02. I selected "Add to Project" from the file menu. '+
   'Then I selected "user resource data" as "file type" in the "Add file to project" dialog. '+
   'Then I selected the jpg file and pressed "OK". '+
   'I pressed the "New Type" button when the "Custom resource type" dialog was displayed. '+
   'I entered "JPG" as "Resource type" and pressed the "OK" button.' + #13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
