unit FAQ001F;
//
// PixelGraphicLibrary - FAQ 1
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    PGImage1: TPGImage;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    PixelGraphicLibraryFAQ0031: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    StatusBar1: TStatusBar;
    procedure Info(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure PGImage1PicBoxOnMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
if PGOpenDialog1.Execute then
   PGImage1.Filename:=PGOpenDialog1.Filename;
end;

procedure TForm1.PGImage1PicBoxOnMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
   PGX, PGY: Integer;
   aRGB: TRGB;
begin
PGX:=PGImage1.PicToGraphicX(X);
PGY:=PGImage1.PicToGraphicY(Y);
aRGB:=PGImage1.LendNoModifyPixelGraphic.Pixels[PGX, PGY];
StatusBar1.Panels[0].Text:='X='+IntToStr(PGX);
StatusBar1.Panels[1].Text:='Y='+IntToStr(PGY);
StatusBar1.Panels[2].Text:='R='+IntToStr(GetRValue(aRGB));
StatusBar1.Panels[3].Text:='G='+IntToStr(GetGValue(aRGB));
StatusBar1.Panels[4].Text:='B='+IntToStr(GetBValue(aRGB));
end;

procedure TForm1.Info(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'Question: I would like to display the color of the PixelGraphic'#39's pixel '+
   'under the cursor. I set Stretch to AlwaysKAR. How can I do this?' + #13#13 +
   'Answer: You can use the TPGImage.PicBoxOnMouseMove event. '+
   'Use the functions TPGImage.PicToGraphicX and TPGImage.PicToGraphicY '+
   'to transform the coordinates to the ones of the TPixelGraphic. '+
   'Note that you should use TPGImage.LendNoModifyPixelGraphic to get a Pointer '+
   'to the PixelGraphic held by TPGImage because you will not modify the PixelGraphic. '+
   'This allows the thread, which might run to calculate the stretched and may be '+
   'dithered image, to go on working.'+#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
