unit Demo17F1;
//
// PixelGraphicLibrary - Demo 17
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBTables, Mask, ExtCtrls, Dialogs, PGraphic, ClipBrd,
  Menus;

type
  TForm1 = class(TForm)
    Table1Number: TAutoIncField;
    Table1Description: TStringField;
    Table1Graphic: TBlobField;
    ScrollBox: TScrollBox;
    Label1: TLabel;
    EditNumber: TDBEdit;
    Label2: TLabel;
    EditDescription: TDBEdit;
    Label3: TLabel;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Panel2: TPanel;
    Table1: TTable;
    Timer1: TTimer;
    PGOpenDialog1: TPGOpenDialog;
    PGImage1: TPGImage;
    LoadFromFileButton: TButton;
    PasteFromClipboardButton: TButton;
    CopyToClipboardButton: TButton;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure DataSource1StateChange(Sender: TObject);
    procedure LoadFromFileButtonClick(Sender: TObject);
    procedure PasteFromClipboardButtonClick(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure CopyToClipboardButtonClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Demo17F2;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
Table1.Databasename:=ExtractFileDir(ParamStr(0));
Table1.Open;
Info1Click(Self);
end;

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
var
   aPG: TPixelGraphic;
   BlobStream: TBlobStream;
begin
CopyToClipboardButton.Enabled:=not Table1Graphic.IsNull;
if (Field=nil) or (Field=Table1Graphic) then
   begin
   BlobStream:=TBlobStream.Create(Table1Graphic, bmRead);
   try
   if BlobStream.Size>0 then
      begin
      aPG:=TPixelGraphic.Create;
      aPG.LoadFromStream(BlobStream);
      PGImage1.TakePixelGraphic(aPG);
      end
   else
      begin
      PGImage1.PixelGraphic:=nil;
      end;
   finally
      BlobStream.Free;
   end; // of try/finally
   end;
end;

procedure TForm1.DataSource1StateChange(Sender: TObject);
begin
LoadFromFileButton.Enabled:=DataSource1.State in [dsEdit, dsInsert];
PasteFromClipboardButton.Enabled:=(DataSource1.State in [dsEdit, dsInsert]) and Clipboard.HasFormat(CF_DIB);
end;

procedure TForm1.LoadFromFileButtonClick(Sender: TObject);
begin
if PGOpenDialog1.execute then
   // Note: You should not tga files, which can't be identified by the first bytes, into a blob stream. 
   Table1Graphic.LoadFromFile(PGOpenDialog1.FileName);
end;

procedure TForm1.PasteFromClipboardButtonClick(Sender: TObject);
var
   aPG: TPixelGraphic;
   BlobStream: TBlobStream;
begin
if Clipboard.HasFormat(CF_DIB) then
   begin
   if Form2.ShowModal = mrOK then
      begin
      aPG:=TPixelGraphic.Create;
      aPG.LoadFromClipboard;
      BlobStream:=TBlobStream.Create(Table1Graphic, bmWrite);
      try
         aPG.SaveToStreamFormat(BlobStream, Form2.ComboBox1.Items[Form2.ComboBox1.ItemIndex]);
      finally
         BlobStream.Free;
      end; // of try/finally
      end;
   end
else
   raise Exception.Create('Clipboard doesn'#39't have CF_DIB');
end;

procedure TForm1.CopyToClipboardButtonClick(Sender: TObject);
begin
PGImage1.LendNoModifyPixelGraphic.SaveToClipboard;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
PasteFromClipboardButton.Enabled:=(DataSource1.State in [dsEdit, dsInsert]) and Clipboard.HasFormat(CF_DIB);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This demonstrates how you can use the PixelGraphicLibrary to read graphics from and write graphics to blob streams.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
